/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.ui.bot.itests.reddeer.util;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import org.eclipse.swt.custom.CLabel;
import org.hamcrest.Matcher;
import org.jboss.reddeer.common.condition.WaitCondition;
import org.jboss.reddeer.common.exception.WaitTimeoutExpiredException;
import org.jboss.reddeer.common.logging.Logger;
import org.jboss.reddeer.common.wait.TimePeriod;
import org.jboss.reddeer.common.wait.WaitUntil;
import org.jboss.reddeer.core.condition.JobIsRunning;
import org.jboss.reddeer.core.condition.WidgetIsFound;
import org.jboss.reddeer.core.matcher.ClassMatcher;
import org.jboss.reddeer.core.matcher.WithMnemonicTextMatcher;
import org.jboss.reddeer.eclipse.equinox.security.ui.StoragePreferencePage;
import org.jboss.reddeer.jface.preference.PreferencePage;
import org.jboss.reddeer.junit.requirement.Requirement;
import org.jboss.reddeer.swt.api.TableItem;
import org.jboss.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;

public class DisableSecureStorageRequirement
implements Requirement<DisableSecureStorage> {
    private static final Logger log = Logger.getLogger(DisableSecureStorageRequirement.class);

    public boolean canFulfill() {
        return true;
    }

    public void fulfill() {
        this.setSecureStorageMasterPasswords(false);
    }

    public void setDeclaration(DisableSecureStorage declaration) {
    }

    public void cleanUp() {
        this.setSecureStorageMasterPasswords(true);
    }

    private void setSecureStorageMasterPasswords(boolean checked) {
        WorkbenchPreferenceDialog preferenceDialog = new WorkbenchPreferenceDialog();
        StoragePreferencePage storagePage = new StoragePreferencePage();
        preferenceDialog.open();
        preferenceDialog.select((PreferencePage)storagePage);
        try {
            try {
                new WaitUntil((WaitCondition)new WidgetIsFound(new Matcher[]{new ClassMatcher(CLabel.class), new WithMnemonicTextMatcher("Secure Storage")}), TimePeriod.NORMAL);
                log.info("Getting master password providers");
                List items = storagePage.getMasterPasswordProviders();
                for (TableItem item : items) {
                    log.info("Uncheking table item: " + item.getText());
                    item.setChecked(checked);
                }
                new WaitUntil((WaitCondition)new JobIsRunning(), TimePeriod.NORMAL, false);
                storagePage.apply();
            }
            catch (WaitTimeoutExpiredException exc) {
                log.error("Secure Storage preferences page has timed out");
                exc.printStackTrace();
                preferenceDialog.ok();
            }
        }
        finally {
            preferenceDialog.ok();
        }
    }

    @Retention(value=RetentionPolicy.RUNTIME)
    @Target(value={ElementType.TYPE})
    public static @interface DisableSecureStorage {
    }
}

