/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.ui.bot.itests.reddeer.util;

import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsNot;
import org.hamcrest.core.StringContains;
import org.jboss.ide.eclipse.as.reddeer.matcher.ServerConsoleContainsNoExceptionMatcher;
import org.jboss.reddeer.common.condition.AbstractWaitCondition;
import org.jboss.reddeer.common.condition.WaitCondition;
import org.jboss.reddeer.common.logging.Logger;
import org.jboss.reddeer.common.wait.TimePeriod;
import org.jboss.reddeer.common.wait.WaitUntil;
import org.jboss.reddeer.common.wait.WaitWhile;
import org.jboss.reddeer.core.condition.JobIsRunning;
import org.jboss.reddeer.eclipse.condition.ConsoleHasNoChange;
import org.jboss.reddeer.eclipse.exception.EclipseLayerException;
import org.jboss.reddeer.eclipse.ui.console.ConsoleView;
import org.jboss.reddeer.eclipse.wst.server.ui.RuntimePreferencePage;
import org.jboss.reddeer.eclipse.wst.server.ui.view.Server;
import org.jboss.reddeer.eclipse.wst.server.ui.view.ServersView;
import org.jboss.reddeer.jface.preference.PreferencePage;
import org.jboss.reddeer.swt.api.Shell;
import org.jboss.reddeer.swt.condition.ShellIsActive;
import org.jboss.reddeer.swt.exception.SWTLayerException;
import org.jboss.reddeer.swt.impl.button.PushButton;
import org.jboss.reddeer.swt.impl.shell.DefaultShell;
import org.jboss.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.junit.Assert;

public class OperateServerTemplate {
    private final Logger LOGGER = Logger.getLogger(this.getClass());
    private ServersView serversView = new ServersView();
    private ConsoleView consoleView = new ConsoleView();
    private String serverName;

    public OperateServerTemplate(String serverName) {
        this.serverName = serverName;
    }

    private String getServerName() {
        return this.serverName;
    }

    public void operateServer() {
        this.serverIsPresentInServersView();
        new WaitWhile((WaitCondition)new JobIsRunning());
        new WaitUntil((WaitCondition)new ServerHasState("Stopped"));
        this.LOGGER.step("Starting server");
        this.startServer();
        this.LOGGER.step("Restarting server");
        this.restartServer();
        this.LOGGER.step("Stopping server");
        this.stopServer();
        this.LOGGER.step("Deleting server");
        this.deleteServer();
    }

    public void startServerSafe() {
        this.serverIsPresentInServersView();
        new WaitWhile((WaitCondition)new JobIsRunning());
        new WaitUntil((WaitCondition)new ServerHasState("Stopped"));
        this.LOGGER.step("Starting server");
        this.startServer();
    }

    public void stopAndDeleteServer() {
        this.LOGGER.step("Stopping server");
        this.stopServer();
        this.LOGGER.step("Deleting server");
        this.deleteServer();
    }

    private void serverIsPresentInServersView() {
        ServersView sw = new ServersView();
        sw.open();
        try {
            sw.getServer(this.getServerName());
        }
        catch (EclipseLayerException e) {
            String failMessage = "Server \"" + this.getServerName() + "\" not found in Servers View.";
            this.LOGGER.error(failMessage, (Throwable)e);
            Assert.fail((String)failMessage);
        }
    }

    public void setUp() {
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.LONG);
        this.serversView.open();
        for (Server server : this.serversView.getServers()) {
            if (server.getLabel().getName().equals(this.serversView.getServer(this.getServerName()).getLabel().getName())) continue;
            server.delete();
        }
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.VERY_LONG);
    }

    public void cleanServerAndConsoleView() {
        try {
            this.LOGGER.step("Trying to close shell \"Warning: server process not terminated\"");
            new DefaultShell("Warning: server process not terminated");
            new PushButton("Yes").click();
            this.LOGGER.step("Warning shell is closed.");
        }
        catch (Exception exception) {}
        new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.LONG);
        this.serversView.open();
        for (Server server : this.serversView.getServers()) {
            server.delete(true);
        }
        this.consoleView.open();
        this.consoleView.clearConsole();
        this.removeAllRuntimes();
    }

    public void startServer() {
        this.serversView.getServer(this.getServerName()).start();
        new WaitUntil((WaitCondition)new ConsoleHasNoChange(TimePeriod.getCustom((long)5L)), TimePeriod.LONG);
        new WaitUntil((WaitCondition)new ServerHasState("Started"));
        this.assertNoException("Starting server");
        this.assertServerState("Starting server", "Started");
    }

    public void restartServer() {
        this.serversView.getServer(this.getServerName()).restart();
        this.tryServerProcessNotTerminated();
        new WaitUntil((WaitCondition)new ConsoleHasNoChange(TimePeriod.getCustom((long)5L)), TimePeriod.LONG);
        new WaitUntil((WaitCondition)new ServerHasState("Started"));
        this.assertNoException("Restarting server");
        this.assertNoError("Restarting server");
        this.assertServerState("Restarting server", "Started");
    }

    public void stopServer() {
        this.serversView.getServer(this.getServerName()).stop();
        this.tryServerProcessNotTerminated();
        new WaitUntil((WaitCondition)new ConsoleHasNoChange(TimePeriod.getCustom((long)5L)), TimePeriod.LONG);
        new WaitUntil((WaitCondition)new ServerHasState("Stopped"));
        this.assertNoException("Stopping server");
        this.assertServerState("Stopping server", "Stopped");
    }

    private void tryServerProcessNotTerminated() {
        try {
            this.LOGGER.step("Trying to close shell \"Warning: server process not terminated\"");
            DefaultShell warningShell = new DefaultShell("Warning: server process not terminated");
            new PushButton("Yes").click();
            new WaitWhile((WaitCondition)new ShellIsActive((Shell)warningShell));
            this.LOGGER.step("Warning shell is closed.");
        }
        catch (SWTLayerException sWTLayerException) {}
    }

    public void deleteServer() {
        this.serversView.getServer(this.getServerName()).delete();
    }

    private void removeAllRuntimes() {
        WorkbenchPreferenceDialog preferenceDialog = new WorkbenchPreferenceDialog();
        preferenceDialog.open();
        RuntimePreferencePage runtimePage = new RuntimePreferencePage();
        preferenceDialog.select((PreferencePage)runtimePage);
        runtimePage.removeAllRuntimes();
        preferenceDialog.ok();
    }

    protected void assertNoException(String message) {
        ConsoleView console = new ConsoleView();
        console.open();
        MatcherAssert.assertThat((String)message, (Object)console, (Matcher)new ServerConsoleContainsNoExceptionMatcher());
    }

    protected void assertNoError(String message) {
        ConsoleView console = new ConsoleView();
        console.open();
        String consoleText = console.getConsoleText();
        if (consoleText != null) {
            MatcherAssert.assertThat((String)message, (Object)consoleText, (Matcher)IsNot.not((Matcher)StringContains.containsString((String)"Error:")));
        } else {
            Assert.fail((String)"Text from console could not be obtained.");
        }
    }

    protected void assertServerState(String message, String state) {
        String textState;
        this.serversView.open();
        try {
            textState = this.serversView.getServer(this.getServerName()).getLabel().getState().getText();
        }
        catch (EclipseLayerException eclipseLayerException) {
            new WaitWhile((WaitCondition)new JobIsRunning(), TimePeriod.VERY_LONG);
            textState = this.serversView.getServer(this.getServerName()).getLabel().getState().getText();
        }
        MatcherAssert.assertThat((String)message, (Object)textState, (Matcher)Is.is((Object)state));
    }

    private class ServerHasState
    extends AbstractWaitCondition {
        private String expectedState;
        private String state;

        private ServerHasState(String expectedState) {
            this.expectedState = expectedState;
        }

        public boolean test() {
            this.state = OperateServerTemplate.this.serversView.getServer(OperateServerTemplate.this.getServerName()).getLabel().getState().getText();
            return this.state.equals(this.state);
        }

        public String description() {
            return "Server in server view is in given state.Expected: \"" + this.expectedState + "\" but was \"" + this.state + "\"";
        }
    }
}

