/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.ui.bot.itests.reddeer.util;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.jboss.reddeer.eclipse.wst.server.ui.RuntimePreferencePage;
import org.jboss.reddeer.jface.preference.PreferencePage;
import org.jboss.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.jboss.tools.as.ui.bot.itests.parametized.CleanEnvironmentUtils;
import org.jboss.tools.as.ui.bot.itests.reddeer.ui.RuntimeDetectionPreferencePage;
import org.jboss.tools.as.ui.bot.itests.reddeer.ui.SearchingForRuntimesDialog;
import org.jboss.tools.runtime.core.model.RuntimePath;
import org.jboss.tools.runtime.ui.RuntimeUIActivator;

public class RuntimeDetectionUtility {
    public static RuntimeDetectionPreferencePage runtimeDetectionPage = new RuntimeDetectionPreferencePage();
    public static RuntimePreferencePage runtimePreferencePage = new RuntimePreferencePage();
    public static WorkbenchPreferenceDialog preferences = new WorkbenchPreferenceDialog();

    public static SearchingForRuntimesDialog addPath(String path) {
        RuntimeUIActivator.getDefault().getModel().addRuntimePath(new RuntimePath(new File(path).getAbsolutePath()));
        runtimeDetectionPage = new RuntimeDetectionPreferencePage();
        preferences.open();
        preferences.select((PreferencePage)runtimeDetectionPage);
        if (!runtimeDetectionPage.getAllPaths().contains(path)) {
            preferences.cancel();
            preferences.open();
            preferences.select((PreferencePage)runtimeDetectionPage);
        }
        return runtimeDetectionPage.search();
    }

    public static SearchingForRuntimesDialog searchFirstPath() {
        runtimeDetectionPage = new RuntimeDetectionPreferencePage();
        preferences.open();
        preferences.select((PreferencePage)runtimeDetectionPage);
        return runtimeDetectionPage.search();
    }

    public static void removeAllPaths() {
        CleanEnvironmentUtils.cleanPaths();
    }

    public static void removeAllServerRuntimes() {
        CleanEnvironmentUtils.cleanServerRuntimes();
    }

    public static void assertServerRuntimesNumber(int expected) {
        preferences.open();
        preferences.select((PreferencePage)runtimePreferencePage);
        List runtimes = runtimePreferencePage.getServerRuntimes();
        MatcherAssert.assertThat((String)("Expected are " + expected + " runtimes but there are:\n" + Arrays.toString(runtimes.toArray())), (Object)runtimes.size(), (Matcher)Is.is((Object)expected));
        preferences.ok();
    }
}

