/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.jdt.integration.ui;

import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.jboss.ide.eclipse.archives.core.build.SaveArchivesJob;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.INamedContainerArchiveNode;
import org.jboss.ide.eclipse.archives.jdt.integration.model.IArchiveLibFileSet;
import org.jboss.ide.eclipse.archives.jdt.integration.ui.LibFilesetWizard;
import org.jboss.ide.eclipse.archives.ui.ArchivesUIMessages;

public class JDTArchivesActionProvider
extends CommonActionProvider {
    private ICommonViewerSite site;
    private Action newLibFilesetAction;
    private Action editLibFilesetAction;
    private Action deleteAction;

    public void init(ICommonActionExtensionSite aSite) {
        this.site = aSite.getViewSite();
        this.createActions();
    }

    protected void createActions() {
        this.newLibFilesetAction = new Action(ArchivesUIMessages.ProjectPackagesView_newLibFilesetAction_label, JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.library_obj.gif")){

            public void run() {
                JDTArchivesActionProvider.this.createLibFileset();
            }
        };
        this.editLibFilesetAction = new Action(ArchivesUIMessages.ProjectPackagesView_editFilesetAction_label, JavaUI.getSharedImages().getImageDescriptor("org.eclipse.jdt.ui.library_obj.gif")){

            public void run() {
                JDTArchivesActionProvider.this.editAction();
            }
        };
        this.deleteAction = new Action(ArchivesUIMessages.ProjectPackagesView_deleteFilesetAction_label, this.platformDescriptor("IMG_TOOL_DELETE")){

            public void run() {
                JDTArchivesActionProvider.this.deleteSelectedNode();
            }
        };
    }

    public void fillContextMenu(IMenuManager manager) {
        IArchiveNode node;
        Separator s;
        if (manager.find("org.jboss.ide.eclipse.archives.ui.providers.initialSeparator") == null) {
            s = new Separator("org.jboss.ide.eclipse.archives.ui.providers.initialSeparator");
            s.setVisible(false);
            manager.add((IContributionItem)s);
        }
        if (manager.find("org.jboss.ide.eclipse.archives.ui.providers.endAddChildSeparator") == null) {
            s = new Separator("org.jboss.ide.eclipse.archives.ui.providers.endAddChildSeparator");
            s.setVisible(false);
            manager.add((IContributionItem)s);
        }
        if ((node = this.getSelectedNode()) instanceof INamedContainerArchiveNode) {
            manager.insertBefore("org.jboss.ide.eclipse.archives.ui.providers.endAddChildSeparator", (IAction)this.newLibFilesetAction);
        }
        if (node instanceof IArchiveLibFileSet) {
            manager.insertAfter("org.jboss.ide.eclipse.archives.ui.providers.endAddChildSeparator", (IAction)this.deleteAction);
            manager.insertAfter("org.jboss.ide.eclipse.archives.ui.providers.endAddChildSeparator", (IAction)this.editLibFilesetAction);
        }
    }

    private void deleteSelectedNode() {
        IArchiveNode node = this.getSelectedNode();
        if (node != null) {
            IArchiveNode parent = node.getParent();
            parent.removeChild(node);
            SaveArchivesJob job = new SaveArchivesJob(parent.getProjectPath());
            job.schedule();
        }
    }

    private void createLibFileset() {
        IArchiveNode selected = this.getSelectedNode();
        WizardDialog dialog = new WizardDialog(this.site.getShell(), (IWizard)new LibFilesetWizard(null, selected));
        dialog.open();
    }

    private void editAction() {
        IArchiveNode node = this.getSelectedNode();
        if (node != null) {
            IArchiveLibFileSet fileset = (IArchiveLibFileSet)node;
            WizardDialog dialog = new WizardDialog(this.site.getShell(), (IWizard)new LibFilesetWizard(fileset, node.getParent()));
            dialog.open();
        }
    }

    private IArchiveNode getSelectedNode() {
        Object selected = this.getSelectedObject();
        if (selected instanceof IArchiveNode) {
            return (IArchiveNode)selected;
        }
        return null;
    }

    private Object getSelectedObject() {
        IStructuredSelection selection = this.getSelection();
        if (selection != null && !selection.isEmpty()) {
            return selection.getFirstElement();
        }
        return null;
    }

    private IStructuredSelection getSelection() {
        return (IStructuredSelection)this.site.getSelectionProvider().getSelection();
    }

    private ImageDescriptor platformDescriptor(String desc) {
        return PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(desc);
    }
}

