/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui.internal.actions;

import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.ui.PlatformUI;
import org.jboss.tools.jmx.core.DeleteConnectionJob;
import org.jboss.tools.jmx.core.DisconnectJob;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.ui.Messages;

public class DeleteConnectionAction
extends Action {
    private IConnectionWrapper[] connection;

    public DeleteConnectionAction(IConnectionWrapper[] wrapper) {
        this.connection = wrapper;
        boolean enabled = true;
        int i = 0;
        while (i < this.connection.length) {
            if (!this.connection[i].getProvider().canDelete(this.connection[i])) {
                enabled = false;
            }
            ++i;
        }
        String key = enabled ? "IMG_TOOL_DELETE" : "IMG_TOOL_DELETE_DISABLED";
        this.setImageDescriptor(PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(key));
        this.setEnabled(enabled);
        this.setText(Messages.DeleteConnection);
    }

    public void run() {
        if (this.connection != null) {
            IConnectionWrapper[] wrapper = this.connection;
            DisconnectJob dj = new DisconnectJob(wrapper);
            DeleteConnectionJob deleteJob = new DeleteConnectionJob(wrapper);
            dj.setNextJob((Job)deleteJob);
            dj.schedule();
        }
    }
}

