/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui.internal.views.navigator;

import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.internal.navigator.NavigatorPlugin;
import org.eclipse.ui.navigator.CommonNavigator;
import org.eclipse.ui.navigator.LinkHelperService;
import org.eclipse.ui.part.ShowInContext;
import org.eclipse.ui.progress.UIJob;
import org.jboss.tools.jmx.ui.Messages;
import org.jboss.tools.jmx.ui.internal.views.navigator.JMXNavigator;

public class UpdateSelectionJob
extends UIJob {
    private CommonNavigator commonNavigator;
    private LinkHelperService linkService;

    public static void launchJob(String viewId) {
        IWorkbenchPart part;
        IWorkbench work = PlatformUI.getWorkbench();
        IWorkbenchWindow window = work.getActiveWorkbenchWindow();
        IWorkbenchPage page = window.getActivePage();
        IViewReference ref = window.getActivePage().findViewReference(viewId);
        if (ref != null && (part = ref.getPart(false)) != null && page.isPartVisible(part) && part instanceof CommonNavigator) {
            new UpdateSelectionJob((CommonNavigator)part).schedule();
        }
    }

    public UpdateSelectionJob(CommonNavigator commonNavigator) {
        super(Messages.UpdatingSelectionJob);
        this.commonNavigator = commonNavigator;
        if (commonNavigator instanceof JMXNavigator) {
            this.linkService = ((JMXNavigator)commonNavigator).getLinkHelperService();
        }
    }

    public IStatus runInUIThread(IProgressMonitor monitor) {
        if (this.linkService != null && !this.commonNavigator.getCommonViewer().getControl().isDisposed()) {
            SafeRunner.run((ISafeRunnable)new ISafeRunnable(){

                public void run() throws Exception {
                    IEditorPart editor;
                    IWorkbenchPage page = UpdateSelectionJob.this.commonNavigator.getSite().getPage();
                    if (page != null && (editor = page.getActiveEditor()) != null) {
                        IEditorInput input = editor.getEditorInput();
                        boolean preLink = UpdateSelectionJob.this.commonNavigator.isLinkingEnabled();
                        if (preLink) {
                            UpdateSelectionJob.this.commonNavigator.setLinkingEnabled(false);
                            try {
                                IStructuredSelection newSelection = UpdateSelectionJob.this.linkService.getSelectionFor(input);
                                UpdateSelectionJob.this.commonNavigator.show(new ShowInContext((Object)input, UpdateSelectionJob.this.commonNavigator.getCommonViewer().getSelection()));
                                if (!newSelection.isEmpty() && !this.allShown((IStructuredSelection)UpdateSelectionJob.this.commonNavigator.getCommonViewer().getSelection(), newSelection)) {
                                    UpdateSelectionJob.this.commonNavigator.selectReveal((ISelection)newSelection);
                                }
                            }
                            finally {
                                UpdateSelectionJob.this.commonNavigator.setLinkingEnabled(true);
                            }
                        }
                    }
                }

                protected boolean allShown(IStructuredSelection navigatorSel, IStructuredSelection editorSel) {
                    List navList = navigatorSel.toList();
                    Iterator i = editorSel.iterator();
                    while (i.hasNext()) {
                        if (navList.contains(i.next())) continue;
                        return false;
                    }
                    return true;
                }

                public void handleException(Throwable e) {
                    String msg = e.getMessage() != null ? e.getMessage() : e.toString();
                    NavigatorPlugin.logError((int)0, (String)msg, (Throwable)e);
                }
            });
        }
        return Status.OK_STATUS;
    }
}

