/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.ui.internal.wizards;

import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.jboss.tools.foundation.ui.xpl.taskwizard.TaskWizard;
import org.jboss.tools.foundation.ui.xpl.taskwizard.WizardFragment;
import org.jboss.tools.jmx.core.IConnectionWrapper;
import org.jboss.tools.jmx.ui.IEditableConnectionWizardPage;
import org.jboss.tools.jmx.ui.JMXUIActivator;
import org.jboss.tools.jmx.ui.Messages;
import org.jboss.tools.jmx.ui.UIExtensionManager;

public class EditConnectionWizard
extends TaskWizard {
    public EditConnectionWizard(IConnectionWrapper connection) {
        super(Messages.EditConnectionWizardTitle, (WizardFragment)new EditConnectionFragment(connection));
    }

    private static class EditConnectionFragment
    extends WizardFragment {
        private IConnectionWrapper con;
        private IEditableConnectionWizardPage rootPage;

        public EditConnectionFragment(IConnectionWrapper connection) {
            this.con = connection;
        }

        protected void createChildFragments(List<WizardFragment> list) {
            UIExtensionManager.ConnectionProviderUI ui = UIExtensionManager.getConnectionProviderUI(this.con.getProvider().getId());
            WizardFragment root = ui.createFragments();
            if (root instanceof IEditableConnectionWizardPage) {
                ((IEditableConnectionWizardPage)root).setInitialConnection(this.con);
                list.add(root);
                this.rootPage = (IEditableConnectionWizardPage)root;
            }
        }

        public void performFinish(IProgressMonitor mon) {
            try {
                IConnectionWrapper xinda = this.rootPage.getConnection();
                if (xinda == this.con) {
                    this.con.getProvider().connectionChanged(this.con);
                } else {
                    this.con.getProvider().removeConnection(this.con);
                    this.con.getProvider().addConnection(xinda);
                }
            }
            catch (CoreException ce) {
                JMXUIActivator.getDefault().getLog().log((IStatus)new Status(4, "org.jboss.tools.jmx.ui", "Error editing JMX connection", (Throwable)ce));
            }
        }
    }
}

