/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.wtp.runtimes.tomcat.itests;

import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.internal.launching.environments.EnvironmentsManager;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.environments.IExecutionEnvironment;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.tools.as.test.core.internal.utils.JREUtils;
import org.jboss.tools.wtp.runtimes.tomcat.itests.Messages;
import org.junit.After;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;

public class AbstractTomcatDetectionTest {
    protected static final String REQUIREMENTS_DIR = String.valueOf(System.getProperty("basedir", ".")) + "/target/requirements/";
    protected static final String TOMCAT_6 = "apache-tomcat-" + System.getProperty("jbosstools.test.tomcat.version.6", "6.0.39");
    protected static final String TOMCAT_6_PATH = String.valueOf(REQUIREMENTS_DIR) + TOMCAT_6;
    protected static final String TOMCAT_7 = "apache-tomcat-" + System.getProperty("jbosstools.test.tomcat.version.7", "7.0.54");
    protected static final String TOMCAT_7_PATH = String.valueOf(REQUIREMENTS_DIR) + TOMCAT_7;
    protected static final String TOMCAT_8 = "apache-tomcat-" + System.getProperty("jbosstools.test.tomcat.version.8", "8.0.8");
    protected static final String TOMCAT_8_PATH = String.valueOf(REQUIREMENTS_DIR) + TOMCAT_8;
    protected static final String UNEXPECTED_RUNTIME_COUNT_ERROR = String.valueOf(Messages.incorrect_number_of_runtimes) + " [ " + REQUIREMENTS_DIR + " ]";
    public static final String JRE_7_HOME;

    static {
        String jre7 = System.getProperty("jbosstools.test.jre.7");
        JRE_7_HOME = jre7 != null && !jre7.trim().isEmpty() ? jre7.trim() : null;
    }

    @BeforeClass
    public static void beforeClass() {
        File tomcat6 = new File(TOMCAT_6_PATH);
        Assert.assertTrue((String)(String.valueOf(TOMCAT_6_PATH) + Messages.is_missing + "'mvn clean pre-integration-test'"), (boolean)tomcat6.exists());
        File tomcat7 = new File(TOMCAT_7_PATH);
        Assert.assertTrue((String)(String.valueOf(TOMCAT_7_PATH) + Messages.is_missing + "'mvn clean pre-integration-test'"), (boolean)tomcat7.exists());
        File tomcat8 = new File(TOMCAT_8_PATH);
        Assert.assertTrue((String)(String.valueOf(TOMCAT_8_PATH) + Messages.is_missing + "'mvn clean pre-integration-test'"), (boolean)tomcat8.exists());
        AbstractTomcatDetectionTest.checkJRE7Availability();
    }

    @AfterClass
    public static void afterClass() {
    }

    @Before
    public void setUp() throws CoreException {
        this.clearAll();
    }

    @After
    public void tearDown() throws CoreException {
        this.clearAll();
    }

    public void clearAll() throws CoreException {
        IServer[] s = ServerCore.getServers();
        int i = 0;
        while (i < s.length) {
            s[i].delete();
            ++i;
        }
        IRuntime[] r = ServerCore.getRuntimes();
        int i2 = 0;
        while (i2 < r.length) {
            r[i2].delete();
            ++i2;
        }
    }

    protected String toString(Object[] runtimes) {
        if (runtimes == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean prependComma = false;
        Object[] objectArray = runtimes;
        int n = runtimes.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (prependComma) {
                sb.append(", ");
            }
            if (o instanceof IRuntime) {
                sb.append(((IRuntime)o).getName());
            } else if (o instanceof IServer) {
                sb.append(((IServer)o).getName());
            } else {
                sb.append(o);
            }
            prependComma = true;
            ++n2;
        }
        return sb.toString();
    }

    private static void checkJRE7Availability() {
        IExecutionEnvironment se7Env = EnvironmentsManager.getDefault().getEnvironment("JavaSE-1.7");
        System.out.println("jre7 home is " + JRE_7_HOME);
        if (JRE_7_HOME != null && !JRE_7_HOME.startsWith("${")) {
            Assert.assertTrue((String)("JRE7 home " + JRE_7_HOME + " does not exist"), (boolean)new File(JRE_7_HOME).exists());
            IVMInstall foundOrCreated = JREUtils.findOrCreateJRE((IPath)new Path(JRE_7_HOME));
            System.out.println(foundOrCreated);
            if (foundOrCreated != null) {
                System.out.println(foundOrCreated.getInstallLocation().getAbsolutePath());
            }
            Assert.assertNotNull((Object)foundOrCreated);
            Assert.assertTrue((String)(String.valueOf(JRE_7_HOME) + " is not a Java 7+ runtime"), (boolean)se7Env.isStrictlyCompatible(foundOrCreated));
            return;
        }
        Assert.assertTrue((String)"Tomcat Detection tests needs to run with at least one JRE7 runtime available. Please set the jbosstools.test.jre.7 property to point to a valid JRE.", (se7Env.getCompatibleVMs().length > 0 ? 1 : 0) != 0);
    }
}

