/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.util;

import java.io.File;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;

public class PortalUtil {
    public static final String GATEIN = "gatein";
    public static int TYPE_PORTAL_UNKNOWN = 0;
    public static int TYPE_PORTAL = 1;
    public static int TYPE_PORTAL_CLUSTER = 2;
    public static int TYPE_PORTLET_CONTAINER = 3;
    public static int TYPE_GATE_IN = 4;
    public static int TYPE_JPP6 = 5;
    private static final String SERVER_DEFAULT_DEPLOY_JBOSS_PORTAL_SAR = "deploy/jboss-portal.sar";
    private static final String SERVER_DEFAULT_DEPLOY_JBOSS_PORTAL_HA_SAR = "deploy/jboss-portal-ha.sar";
    private static final String SERVER_DEFAULT_DEPLOY_SIMPLE_PORTAL = "deploy/simple-portal";
    private static final String SERVER_DEFAULT_DEPLOY_SIMPLE_PORTAL_SAR = "deploy/simple-portal.sar";
    private static final String SERVER_DEFAULT_DEPLOY_GATEIN = "deploy/gatein.ear";
    private static final String SIMPLE_PORTAL_PATH = "simple-portal";
    private static final String PORTAL_PATH = "portal";

    public static int getServerPortalType(IServer server) {
        IRuntime rt = server.getRuntime();
        IJBossServerRuntime jbsrt = (IJBossServerRuntime)rt.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        return PortalUtil.getServerPortalType(jbsrt);
    }

    public static int getServerPortalType(IJBossServerRuntime runtime) {
        IPath location;
        IPath configPath = runtime.getConfigurationFullPath();
        File configFile = configPath.toFile();
        if (PortalUtil.exists(configFile, SERVER_DEFAULT_DEPLOY_JBOSS_PORTAL_SAR)) {
            return TYPE_PORTAL;
        }
        if (PortalUtil.exists(configFile, SERVER_DEFAULT_DEPLOY_JBOSS_PORTAL_HA_SAR)) {
            return TYPE_PORTAL_CLUSTER;
        }
        if (PortalUtil.exists(configFile, SERVER_DEFAULT_DEPLOY_SIMPLE_PORTAL) || PortalUtil.exists(configFile, SERVER_DEFAULT_DEPLOY_SIMPLE_PORTAL_SAR)) {
            return TYPE_PORTLET_CONTAINER;
        }
        if (PortalUtil.exists(configFile, SERVER_DEFAULT_DEPLOY_GATEIN)) {
            return TYPE_GATE_IN;
        }
        if (runtime.getRuntime() != null && PortalUtil.exists((location = runtime.getRuntime().getLocation()).toFile(), GATEIN)) {
            return TYPE_JPP6;
        }
        return TYPE_PORTAL_UNKNOWN;
    }

    public static String getPortalSuffix(IJBossServerRuntime runtime) {
        int type = PortalUtil.getServerPortalType(runtime);
        if (type != TYPE_PORTAL_UNKNOWN) {
            if (type == TYPE_PORTLET_CONTAINER) {
                return SIMPLE_PORTAL_PATH;
            }
            return PORTAL_PATH;
        }
        return null;
    }

    private static boolean exists(File location, String portalDir) {
        if (Platform.getOS().equals("win32")) {
            portalDir = portalDir.replace("/", "\\");
        }
        File file = new File(location, portalDir);
        return file.exists();
    }
}

