/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.util;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.RuntimeWorkingCopy;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.wtp.core.Messages;

public class RuntimeUtils {
    public static IJBossServerRuntime getJBossServerRuntime(IServerAttributes server) {
        IRuntime rt = null;
        if (server != null) {
            rt = server.getRuntime();
        }
        IJBossServerRuntime jbrt = null;
        if (rt != null) {
            jbrt = (IJBossServerRuntime)rt.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        }
        return jbrt;
    }

    public static IJBossServerRuntime checkedGetJBossServerRuntime(IServerAttributes server) throws CoreException {
        IJBossServerRuntime jbrt = RuntimeUtils.getJBossServerRuntime(server);
        if (jbrt == null) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.wtp.core", NLS.bind((String)Messages.ServerRuntimeNotFound, (Object)server.getName())));
        }
        return jbrt;
    }

    public static IJBossServerRuntime getJBossServerRuntime(IRuntime runtime) {
        if (runtime == null) {
            return null;
        }
        return (IJBossServerRuntime)runtime.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
    }

    public static boolean isEAP(IRuntime runtime) {
        return runtime != null && RuntimeUtils.isEAP(runtime.getRuntimeType());
    }

    public static boolean isEAP(IRuntimeType type) {
        return type != null && type.getId() != null && type.getId().startsWith("org.jboss.ide.eclipse.as.runtime.eap.");
    }

    public static IJBossServerRuntime checkedGetJBossServerRuntime(IRuntime runtime) throws CoreException {
        IJBossServerRuntime jbossRuntime = RuntimeUtils.getJBossServerRuntime(runtime);
        if (jbossRuntime == null) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.wtp.core", NLS.bind((String)Messages.ServerRuntimeNotFound, (Object)(runtime == null ? "null" : runtime.getName()))));
        }
        return jbossRuntime;
    }

    public static IRuntime createRuntime(String runtimeTypeId, String homeDir, String config, IVMInstall install) throws CoreException {
        return RuntimeUtils.createRuntime(runtimeTypeId, runtimeTypeId, homeDir, config, install);
    }

    public static IRuntime createRuntime(String runtimeTypeId, String name, String homeDir, String config, IVMInstall install) throws CoreException {
        IRuntimeType[] runtimeTypes = ServerUtil.getRuntimeTypes(null, null, (String)runtimeTypeId);
        IRuntimeType runtimeType = runtimeTypes[0];
        IRuntimeWorkingCopy runtimeWC = runtimeType.createRuntime(null, (IProgressMonitor)new NullProgressMonitor());
        runtimeWC.setName(name);
        runtimeWC.setLocation((IPath)new Path(homeDir));
        if (install != null) {
            ((RuntimeWorkingCopy)runtimeWC).setAttribute("PROPERTY_VM_ID", install.getId());
            ((RuntimeWorkingCopy)runtimeWC).setAttribute("PROPERTY_VM_TYPE_ID", install.getVMInstallType().getId());
        }
        ((RuntimeWorkingCopy)runtimeWC).setAttribute("org.jboss.ide.eclipse.as.core.runtime.configurationName", config);
        IRuntime savedRuntime = runtimeWC.save(true, (IProgressMonitor)new NullProgressMonitor());
        return savedRuntime;
    }

    public static IRuntime createRuntime(String runtimeId, String homeDir, String config) throws CoreException {
        return RuntimeUtils.createRuntime(runtimeId, homeDir, config, JavaRuntime.getDefaultVMInstall());
    }

    public static String getRuntimeTypeId(IServer server) {
        return RuntimeUtils.getRuntimeTypeId(RuntimeUtils.getRuntimeType(server));
    }

    public static String getRuntimeTypeId(IRuntime rt) {
        return RuntimeUtils.getRuntimeTypeId(RuntimeUtils.getRuntimeType(rt));
    }

    public static String getRuntimeTypeId(IServerType serverType) {
        return RuntimeUtils.getRuntimeTypeId(RuntimeUtils.getRuntimeType(serverType));
    }

    public static String getRuntimeTypeId(IRuntimeType type) {
        return type == null ? null : type.getId();
    }

    public static IRuntimeType getRuntimeType(IServer server) {
        return server == null ? null : RuntimeUtils.getRuntimeType(server.getServerType());
    }

    public static IRuntimeType getRuntimeType(IServerType server) {
        return server == null ? null : server.getRuntimeType();
    }

    public static IRuntimeType getRuntimeType(IRuntime runtime) {
        return runtime == null ? null : runtime.getRuntimeType();
    }
}

