/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.debug;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerEvent;
import org.jboss.ide.eclipse.as.core.server.UnitedServerListener;
import org.jboss.ide.eclipse.as.wtp.core.ASWTPToolsPlugin;
import org.jboss.ide.eclipse.as.wtp.core.debug.RemoteDebugUtils;

public class AttachDebuggerServerListener
implements IServerListener {
    private ILaunch debuggerLaunch = null;
    private boolean registerDebuggerLaunch;

    public AttachDebuggerServerListener(boolean registerDebuggerLaunch) {
        this.registerDebuggerLaunch = registerDebuggerLaunch;
    }

    public void serverChanged(ServerEvent event) {
        if (UnitedServerListener.serverSwitchesToState(event, 2)) {
            this.serverStarted(event);
        } else if (UnitedServerListener.serverSwitchesToState(event, 4)) {
            event.getServer().removeServerListener((IServerListener)this);
        }
    }

    protected void serverStarted(ServerEvent event) {
        event.getServer().removeServerListener((IServerListener)this);
        IServer s = event.getServer();
        int debugPort = this.getDebugPort(s);
        try {
            this.debuggerLaunch = this.attachRemoteDebugger(event.getServer(), debugPort, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException ce) {
            ASWTPToolsPlugin.pluginLog().logError((Throwable)ce);
        }
    }

    protected int getDebugPort(IServer s) {
        return RemoteDebugUtils.get().getDebugPort(s);
    }

    protected ILaunch attachRemoteDebugger(IServer server, int debugPort, IProgressMonitor mon) throws CoreException {
        return RemoteDebugUtils.get().attachRemoteDebugger(server, debugPort, this.registerDebuggerLaunch, mon);
    }

    protected boolean shouldRegisterDebuggerLaunch() {
        return this.registerDebuggerLaunch;
    }

    public ILaunch getLaunch() {
        return this.debuggerLaunch;
    }
}

