/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.server.behavior;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.model.ServerBehaviourDelegate;
import org.jboss.ide.eclipse.as.wtp.core.ASWTPToolsPlugin;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ControllerEnvironment;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IControllableServerBehavior;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ILaunchServerController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IModuleStateController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IPublishController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IServerShutdownController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.ISubsystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.SubsystemModel;

public class ControllableServerBehavior
extends ServerBehaviourDelegate
implements IControllableServerBehavior {
    public static final String PROPERTY_PREFIX = "SUBSYSTEM_OVERRIDE_";
    protected HashMap<String, Object> sharedData = new HashMap();
    protected final Object serverStateLock = new Object();

    @Override
    public synchronized Object getSharedData(String key) {
        return this.sharedData.get(key);
    }

    @Override
    public synchronized void putSharedData(String key, Object o) {
        this.sharedData.put(key, o);
    }

    @Override
    public ISubsystemController getController(String system) throws CoreException {
        if ("publish".equals(system)) {
            return this.getPublishController();
        }
        if ("modules".equals(system)) {
            return this.getModuleStateController();
        }
        if ("shutdown".equals(system)) {
            return this.getShutdownController();
        }
        if ("launch".equals(system)) {
            return this.getLaunchController();
        }
        return this.getController(system, null);
    }

    @Override
    public ISubsystemController getWorkingCopyController(String system, IServerWorkingCopy wc) throws CoreException {
        ISubsystemController controller = this.getController(system);
        controller.initialize((IServerAttributes)wc, null, null);
        return controller;
    }

    @Override
    public ISubsystemController getController(String system, ControllerEnvironment env) throws CoreException {
        ISubsystemController ret = this.getOverrideController(system, env);
        if (ret == null) {
            ret = SubsystemModel.getInstance().createSubsystemController((IServerAttributes)this.getServer(), system, env == null ? null : env.getMap());
        }
        if (ret == null) {
            throw new CoreException((IStatus)new Status(4, "org.jboss.ide.eclipse.as.wtp.core", 0, "Unable to locate system " + system + " for server " + this.getServer().getName(), null));
        }
        return ret;
    }

    protected ISubsystemController getOverrideController(String system, ControllerEnvironment env) throws CoreException {
        Map<String, Object> envMap;
        String propOverride = PROPERTY_PREFIX + system;
        String val = this.getServer().getAttribute(propOverride, null);
        ISubsystemController ret = null;
        Map<String, Object> map = envMap = env == null ? null : env.getMap();
        if (val != null) {
            ret = SubsystemModel.getInstance().createControllerForSubsystem(this.getServer(), this.getServer().getServerType().getId(), system, val, envMap);
        }
        return ret;
    }

    protected IPublishController getPublishController() throws CoreException {
        return (IPublishController)this.getController("publish", null);
    }

    protected IModuleStateController getModuleStateController() throws CoreException {
        return (IModuleStateController)this.getController("modules", null);
    }

    protected IServerShutdownController getShutdownController() throws CoreException {
        return (IServerShutdownController)this.getController("shutdown", null);
    }

    protected ILaunchServerController getLaunchController() throws CoreException {
        return (ILaunchServerController)this.getController("launch", null);
    }

    public void setupLaunchConfiguration(ILaunchConfigurationWorkingCopy workingCopy, IProgressMonitor monitor) throws CoreException {
        ILaunchServerController controller = this.getLaunchController();
        controller.setupLaunchConfiguration(workingCopy, monitor);
    }

    protected void publishFinish(IProgressMonitor monitor) throws CoreException {
        IPublishController controller = this.getPublishController();
        controller.publishFinish(monitor);
    }

    protected void publishModule(int kind, int deltaKind, IModule[] module, IProgressMonitor monitor) throws CoreException {
        IPublishController controller = this.getPublishController();
        int result = controller.publishModule(kind, deltaKind, module, monitor);
        this.setModulePublishState(module, result);
    }

    protected void publishServer(int kind, IProgressMonitor monitor) throws CoreException {
        IPublishController controller = this.getPublishController();
        controller.publishServer(kind, monitor);
    }

    protected void publishStart(IProgressMonitor monitor) throws CoreException {
        IPublishController controller = this.getPublishController();
        controller.publishStart(monitor);
    }

    public boolean canRestartModule(IModule[] module) {
        try {
            IModuleStateController controller = this.getModuleStateController();
            return controller.canRestartModule(module);
        }
        catch (CoreException ce) {
            ASWTPToolsPlugin.log((IStatus)new Status(4, "org.jboss.ide.eclipse.as.wtp.core", "Unable to locate a module state controller for the given server"));
            return false;
        }
    }

    public void startModule(IModule[] module, IProgressMonitor monitor) throws CoreException {
        IModuleStateController controller = this.getModuleStateController();
        int newState = controller.startModule(module, monitor);
        this.setModuleState(module, newState);
    }

    public void stopModule(IModule[] module, IProgressMonitor monitor) throws CoreException {
        IModuleStateController controller = this.getModuleStateController();
        int newState = controller.stopModule(module, monitor);
        this.setModuleState(module, newState);
    }

    public void restartModule(IModule[] module, IProgressMonitor monitor) throws CoreException {
        IModuleStateController controller = this.getModuleStateController();
        int newState = controller.restartModule(module, monitor);
        this.setModuleState(module, newState);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServerStarting() {
        Object object = this.serverStateLock;
        synchronized (object) {
            this.setServerState(1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServerStarted() {
        Object object = this.serverStateLock;
        synchronized (object) {
            this.setServerState(2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServerStopping() {
        Object object = this.serverStateLock;
        synchronized (object) {
            this.setServerState(3);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setServerStopped() {
        Object object = this.serverStateLock;
        synchronized (object) {
            this.setServerState(4);
        }
        this.setRunMode(null);
        this.setModulesStopped(new IModule[0], this.getServer().getModules());
    }

    protected void setModulesStopped(IModule[] parent, IModule[] children) {
        if (children == null) {
            return;
        }
        int i = 0;
        while (i < children.length) {
            IModule[] combined = this.combine(parent, children[i]);
            this.setModuleState(combined, 0);
            IModule[] children2 = this.getServer().getChildModules(combined, (IProgressMonitor)new NullProgressMonitor());
            this.setModulesStopped(combined, children2);
            ++i;
        }
    }

    private IModule[] combine(IModule[] module, IModule newMod) {
        IModule[] retval = new IModule[module.length + 1];
        int i = 0;
        while (i < module.length) {
            retval[i] = module[i];
            ++i;
        }
        retval[retval.length - 1] = newMod;
        return retval;
    }

    public void stop(boolean force) {
        try {
            IServerShutdownController con = this.getShutdownController();
            if (con != null) {
                con.stop(force);
            }
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    public IStatus canStart(String launchMode) {
        try {
            ILaunchServerController con = this.getLaunchController();
            if (con != null) {
                return con.canStart(launchMode);
            }
            return Status.CANCEL_STATUS;
        }
        catch (CoreException ce) {
            return ce.getStatus();
        }
    }

    public IStatus canStop() {
        try {
            IServerShutdownController con = this.getShutdownController();
            if (con != null) {
                return con.canStop();
            }
            return Status.CANCEL_STATUS;
        }
        catch (CoreException ce) {
            return ce.getStatus();
        }
    }

    public void setRunMode(String mode) {
        this.setMode(mode);
    }

    public IStatus canPublish() {
        try {
            return this.getPublishController().canPublish();
        }
        catch (CoreException ce) {
            ASWTPToolsPlugin.log(ce.getStatus());
            return ce.getStatus();
        }
    }

    public boolean canPublishModule(IModule[] module) {
        try {
            return this.getPublishController().canPublishModule(module);
        }
        catch (CoreException ce) {
            ASWTPToolsPlugin.log(ce.getStatus());
            return false;
        }
    }
}

