/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.server.launch;

import java.util.HashMap;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerListener;
import org.eclipse.wst.server.core.ServerEvent;
import org.jboss.ide.eclipse.as.core.server.UnitedServerListener;
import org.jboss.ide.eclipse.as.wtp.core.Messages;

public class ServerProcess
implements IProcess,
IServerListener {
    protected ILaunch launch;
    protected IServer server;
    private String label;
    protected HashMap<String, String> attributes;
    protected boolean complete = false;

    public ServerProcess(ILaunch launch, IServer server) {
        this(launch, server, ServerProcess.getDefaultLaunchLabel(launch.getLaunchMode()));
    }

    public ServerProcess(ILaunch launch, IServer server, String label) {
        this.launch = launch;
        this.server = server;
        this.label = label;
        this.attributes = new HashMap(5);
        server.addServerListener((IServerListener)this, 17);
    }

    public String getAttribute(String arg0) {
        return this.attributes.get(arg0);
    }

    public void setAttribute(String arg0, String arg1) {
        this.attributes.put(arg0, arg1);
    }

    protected void fireCreationEvent() {
        this.fireEvent(new DebugEvent((Object)this, 4));
    }

    protected void fireEvent(DebugEvent event) {
        DebugPlugin manager = DebugPlugin.getDefault();
        if (manager != null) {
            manager.fireDebugEventSet(new DebugEvent[]{event});
        }
    }

    protected void fireTerminateEvent() {
        this.fireEvent(new DebugEvent((Object)this, 8));
    }

    protected void fireChangeEvent() {
        this.fireEvent(new DebugEvent((Object)this, 16));
    }

    public int getExitValue() throws DebugException {
        return 0;
    }

    private static String getDefaultLaunchLabel(String mode) {
        String pattern = Messages.RunOnMessage;
        if ("profile".equals(mode)) {
            pattern = Messages.ProfileOnMessage;
        } else if ("debug".equals(mode)) {
            pattern = Messages.DebugOnMessage;
        }
        return pattern;
    }

    public String getLabel() {
        return this.label;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IStreamsProxy getStreamsProxy() {
        return null;
    }

    public <T> T getAdapter(Class<T> arg0) {
        return null;
    }

    public boolean canTerminate() {
        return !this.complete && this.server.getServerState() == 2;
    }

    public boolean isTerminated() {
        return this.complete && this.server.getServerState() == 4;
    }

    public void terminate() throws DebugException {
        this.server.stop(true);
    }

    public void serverChanged(ServerEvent event) {
        if (UnitedServerListener.serverSwitchesToState(event, 2)) {
            this.fireCreationEvent();
        } else if (UnitedServerListener.serverSwitchesToState(event, 4)) {
            this.fireTerminateEvent();
            this.complete = true;
            this.server.removeServerListener((IServerListener)this);
        }
    }
}

