/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.wtp.core.vcf;

import java.util.ArrayList;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.jst.j2ee.internal.project.J2EEProjectUtilities;
import org.eclipse.jst.j2ee.project.JavaEEProjectUtilities;
import org.eclipse.jst.jee.application.ICommonModule;
import org.eclipse.wst.common.componentcore.internal.ReferencedComponent;
import org.eclipse.wst.common.componentcore.internal.StructureEdit;
import org.eclipse.wst.common.componentcore.internal.WorkbenchComponent;
import org.eclipse.wst.common.componentcore.internal.builder.DependencyGraphManager;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualComponent;
import org.eclipse.wst.common.componentcore.internal.util.IComponentImplFactory;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.jboss.ide.eclipse.as.wtp.core.vcf.IJBTComponent;
import org.jboss.ide.eclipse.as.wtp.core.vcf.JBTVirtualArchiveComponent;
import org.jboss.ide.eclipse.as.wtp.core.vcf.JBTVirtualFolder;

public class JBTVirtualComponent
extends VirtualComponent
implements IJBTComponent,
IComponentImplFactory {
    private IVirtualReference[] cachedReferences;
    private long depGraphModStamp;

    public JBTVirtualComponent() {
    }

    public JBTVirtualComponent(IProject aProject, IPath aRuntimePath) {
        super(aProject, aRuntimePath);
    }

    public IVirtualComponent createComponent(IProject aProject) {
        return new JBTVirtualComponent(aProject, (IPath)new Path("/"));
    }

    public IVirtualComponent createArchiveComponent(IProject aProject, String archiveLocation, IPath aRuntimePath) {
        return new JBTVirtualArchiveComponent(aProject, archiveLocation, aRuntimePath);
    }

    public IVirtualFolder createFolder(IProject aProject, IPath aRuntimePath) {
        return new JBTVirtualFolder(aProject, aRuntimePath, this);
    }

    public IVirtualReference[] getReferences() {
        this.cachedReferences = JBTVirtualComponent.getHardReferences((IVirtualComponent)this);
        return this.cachedReferences;
    }

    public IVirtualReference[] getCachedReferences() {
        if (this.cachedReferences != null && this.checkIfStillValid()) {
            return this.cachedReferences;
        }
        this.depGraphModStamp = DependencyGraphManager.getInstance().getModStamp();
        return null;
    }

    private boolean checkIfStillValid() {
        return DependencyGraphManager.getInstance().checkIfStillValid(this.depGraphModStamp);
    }

    private static IVirtualReference[] getHardReferences(IVirtualComponent component) {
        StructureEdit core = null;
        ArrayList<IVirtualReference> hardReferences = new ArrayList<IVirtualReference>();
        try {
            core = StructureEdit.getStructureEditForRead((IProject)component.getProject());
            if (core != null && core.getComponent() != null) {
                WorkbenchComponent component2 = core.getComponent();
                if (component != null) {
                    EList referencedComponents = component2.getReferencedComponents();
                    for (ReferencedComponent referencedComponent : referencedComponents) {
                        IVirtualComponent referencedIVirtualComponent;
                        IVirtualReference vReference;
                        if (referencedComponent == null || (vReference = StructureEdit.createVirtualReference((IVirtualComponent)component, (ReferencedComponent)referencedComponent)) == null || (referencedIVirtualComponent = vReference.getReferencedComponent()) == null || !referencedIVirtualComponent.exists()) continue;
                        if (vReference.getDependencyType() == 0) {
                            String archiveName = JBTVirtualComponent.getArchiveName(referencedIVirtualComponent, referencedComponent);
                            vReference.setArchiveName(archiveName);
                        }
                        hardReferences.add(vReference);
                    }
                }
            }
        }
        finally {
            if (core != null) {
                core.dispose();
            }
        }
        return hardReferences.toArray(new IVirtualReference[hardReferences.size()]);
    }

    protected static String getArchiveName(IVirtualComponent referencedIVirtualComponent, ReferencedComponent referencedComponent) {
        String archiveName = null;
        archiveName = referencedComponent.getDependentObject() != null ? ((ICommonModule)referencedComponent.getDependentObject()).getUri() : (referencedIVirtualComponent instanceof IJBTComponent ? JBTVirtualComponent.getJBTComponentArchiveName(referencedIVirtualComponent, referencedComponent) : JBTVirtualComponent.legacy_getWTPComponentArchiveName(referencedIVirtualComponent, referencedComponent));
        return archiveName;
    }

    protected static String getJBTComponentArchiveName(IVirtualComponent moduleComp, ReferencedComponent ref) {
        return ref.getArchiveName();
    }

    protected static String legacy_getWTPComponentArchiveName(IVirtualComponent moduleComp, ReferencedComponent ref) {
        String archiveName = null;
        if (moduleComp.isBinary()) {
            String string = JBTVirtualComponent.legacy_getJarURI(ref, moduleComp);
        } else {
            IProject referencedProject;
            archiveName = ref.getArchiveName() != null ? ref.getArchiveName() : (JavaEEProjectUtilities.isDynamicWebProject((IProject)(referencedProject = moduleComp.getProject())) || J2EEProjectUtilities.isStaticWebProject((IProject)referencedProject) ? String.valueOf(moduleComp.getName()) + ".war" : (JavaEEProjectUtilities.isJCAProject((IProject)referencedProject) ? String.valueOf(moduleComp.getName()) + ".rar" : (JavaEEProjectUtilities.isUtilityProject((IProject)referencedProject) ? JBTVirtualComponent.legacy_getJarURI(ref, moduleComp) : String.valueOf(moduleComp.getName()) + ".jar")));
        }
        return archiveName;
    }

    protected static String legacy_getJarURI(ReferencedComponent ref, IVirtualComponent moduleComp) {
        String uri = null;
        if (uri == null || uri.length() < 0) {
            uri = moduleComp.isBinary() ? new Path(moduleComp.getName()).lastSegment() : String.valueOf(moduleComp.getName()) + ".jar";
        } else {
            String prefix = ref.getRuntimePath().makeRelative().toString();
            if (prefix.length() > 0) {
                uri = String.valueOf(prefix) + "/" + uri;
            }
        }
        return uri;
    }

    public boolean canNestInsideEar() {
        return true;
    }
}

