/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.internal.management.wf11;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.RealmCallback;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.as.controller.client.ModelControllerClientConfiguration;
import org.jboss.as.controller.client.helpers.standalone.DeploymentAction;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlan;
import org.jboss.as.controller.client.helpers.standalone.DeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.InitialDeploymentPlanBuilder;
import org.jboss.as.controller.client.helpers.standalone.ServerDeploymentManager;
import org.jboss.as.controller.client.helpers.standalone.UndeployDeploymentPlanBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.ide.eclipse.as.internal.management.wf11.DeploymentOperationResult;
import org.jboss.ide.eclipse.as.internal.management.wf11.Messages;
import org.jboss.ide.eclipse.as.internal.management.wf11.WildFly11ManagerUtil;
import org.jboss.ide.eclipse.as.management.core.IAS7ManagementDetails;
import org.jboss.ide.eclipse.as.management.core.IJBoss7DeploymentResult;
import org.jboss.ide.eclipse.as.management.core.IncrementalManagementModel;
import org.jboss.ide.eclipse.as.management.core.JBoss7DeploymentState;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManangerException;
import org.jboss.ide.eclipse.as.management.core.JBoss7ServerState;
import org.wildfly.security.auth.callback.CallbackUtil;
import org.wildfly.security.auth.callback.CredentialCallback;
import org.wildfly.security.auth.callback.OptionalNameCallback;
import org.wildfly.security.credential.Credential;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.password.Password;
import org.wildfly.security.password.interfaces.ClearPassword;
import org.wildfly.security.password.interfaces.DigestPassword;
import org.wildfly.security.util.CodePointIterator;

public class WildFly11Manager {
    public static final int DEFAULT_REQUEST_TIMEOUT = 5000;
    private ModelControllerClient client;
    private ServerDeploymentManager manager;
    private IAS7ManagementDetails details;

    public WildFly11Manager(IAS7ManagementDetails details) throws JBoss7ManangerException {
        try {
            this.details = details;
            Object timeout = details.getProperty("PROPERTY_TIMEOUT");
            int timeout2 = !(timeout instanceof Integer) ? 5000 : (Integer)timeout;
            ModelControllerClientConfiguration.Builder b = new ModelControllerClientConfiguration.Builder().setHostName(details.getHost()).setPort(details.getManagementPort()).setHandler(this.getCallbackHandler()).setProtocol("http-remoting").setConnectionTimeout(timeout2).setSaslOptions(Collections.emptyMap());
            ModelControllerClientConfiguration config = b.build();
            this.client = ModelControllerClient.Factory.create((ModelControllerClientConfiguration)config);
            this.manager = ServerDeploymentManager.Factory.create((ModelControllerClient)this.client);
        }
        catch (RuntimeException uhe) {
            throw new JBoss7ManangerException((Throwable)uhe);
        }
    }

    protected CallbackHandler getCallbackHandler() {
        return new ToolsWF11CallbackHandler();
    }

    public IJBoss7DeploymentResult undeploySync(String name, boolean removeFile, IProgressMonitor monitor) throws JBoss7ManangerException {
        String task = "Undeploy via management: " + name;
        monitor.beginTask(task, 100);
        DeploymentOperationResult result = (DeploymentOperationResult)this.undeploy(name, removeFile);
        monitor.worked(5);
        this.waitFor(result, task, (IProgressMonitor)new SubProgressMonitor(monitor, 95));
        monitor.done();
        return result;
    }

    private void waitFor(DeploymentOperationResult result, String task, IProgressMonitor monitor) throws JBoss7ManangerException {
        SubMonitor progress = SubMonitor.convert((IProgressMonitor)monitor);
        progress.beginTask("Waiting for task to complete: " + task, -1);
        while (!monitor.isCanceled() && !result.isDone()) {
            progress.worked(1);
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        if (monitor.isCanceled()) {
            result.cancel();
            throw new JBoss7ManangerException("Operation canceled: " + task);
        }
        result.getStatus();
        monitor.done();
    }

    public IJBoss7DeploymentResult deploySync(String name, File file, boolean add, String[] explodedPaths, IProgressMonitor monitor) throws JBoss7ManangerException {
        String task = "Deploy via management: " + name;
        monitor.beginTask(task, 100);
        DeploymentOperationResult result = (DeploymentOperationResult)this.deploy(name, file, explodedPaths, add);
        monitor.worked(5);
        this.waitFor(result, task, (IProgressMonitor)new SubProgressMonitor(monitor, 95));
        monitor.done();
        return result;
    }

    public IJBoss7DeploymentResult undeploy(String name, boolean removeFile) throws JBoss7ManangerException {
        try {
            Object builder = this.manager.newDeploymentPlan();
            builder = removeFile ? builder.undeploy(name).andRemoveUndeployed() : builder.undeploy(name);
            return new DeploymentOperationResult(builder.getLastAction(), this.manager.execute(builder.build()));
        }
        catch (Exception e) {
            throw new JBoss7ManangerException((Throwable)e);
        }
    }

    public IJBoss7DeploymentResult remove(String name) throws JBoss7ManangerException {
        try {
            InitialDeploymentPlanBuilder builder = this.manager.newDeploymentPlan();
            builder = builder.remove(name);
            return new DeploymentOperationResult(builder.getLastAction(), this.manager.execute(builder.build()));
        }
        catch (Exception e) {
            throw new JBoss7ManangerException((Throwable)e);
        }
    }

    public IJBoss7DeploymentResult deploy(File file) throws JBoss7ManangerException {
        return this.deploy(file.getName(), file, new String[]{file.getName()}, true);
    }

    public IJBoss7DeploymentResult add(String name, File file) throws JBoss7ManangerException {
        try {
            return this.execute((DeploymentPlanBuilder)this.manager.newDeploymentPlan().add(name, file));
        }
        catch (IOException e) {
            throw new JBoss7ManangerException((Throwable)e);
        }
    }

    private ArrayList<String> getZippedPathsForDeployment(String deploymentName) {
        ModelNode request = new ModelNode();
        request.get("operation").set("browse-content");
        request.get("address").add("deployment", deploymentName);
        request.get("archive").set(true);
        ModelNode result = null;
        try {
            result = this.execute(request);
        }
        catch (JBoss7ManangerException jBoss7ManangerException) {
            // empty catch block
        }
        ArrayList<String> zipped = null;
        if (result.getType() == ModelType.LIST) {
            zipped = new ArrayList<String>();
            for (ModelNode content : result.asList()) {
                if (!content.hasDefined("path")) continue;
                ModelNode path = content.get("path");
                String pathStr = path == null ? null : path.asString();
                zipped.add(pathStr);
            }
        } else if (result.getType() == ModelType.UNDEFINED) {
            zipped = new ArrayList();
        }
        return zipped;
    }

    public void explode(String deploymentName, String[] paths) throws JBoss7ManangerException {
        if (paths.length == 0) {
            return;
        }
        ArrayList<String> zipped = this.getZippedPathsForDeployment(deploymentName);
        try {
            UndeployDeploymentPlanBuilder b = this.manager.newDeploymentPlan().undeploy(deploymentName);
            int i = 0;
            while (i < paths.length) {
                if (zipped == null || zipped.contains(paths[i])) {
                    b = b.explodeDeploymentContent(deploymentName, paths[i]);
                }
                ++i;
            }
            b = b.deploy(deploymentName);
            DeploymentOperationResult dor = new DeploymentOperationResult(b.getLastAction(), this.manager.execute(b.build()));
            this.waitFor(dor, "Deploying Module " + deploymentName, (IProgressMonitor)new NullProgressMonitor());
        }
        catch (Exception e) {
            throw new JBoss7ManangerException((Throwable)e);
        }
    }

    public IJBoss7DeploymentResult deploy(String name, File file, String[] explodedPaths, boolean add) throws JBoss7ManangerException {
        try {
            InitialDeploymentPlanBuilder b = this.manager.newDeploymentPlan();
            if (add) {
                b = b.add(name, file);
            }
            int i = 0;
            while (i < explodedPaths.length) {
                if (name.equals(explodedPaths[i])) {
                    b = b.explodeDeployment(explodedPaths[i]);
                } else {
                    b.explodeDeploymentContent(name, explodedPaths[i]);
                }
                ++i;
            }
            return this.execute(b.deploy(name));
        }
        catch (IOException e) {
            throw new JBoss7ManangerException((Throwable)e);
        }
    }

    public IJBoss7DeploymentResult replace(File file) throws JBoss7ManangerException {
        return this.replace(file.getName(), file);
    }

    public IJBoss7DeploymentResult replace(String name, File file) throws JBoss7ManangerException {
        try {
            return this.execute(this.manager.newDeploymentPlan().replace(name, file));
        }
        catch (IOException e) {
            throw new JBoss7ManangerException((Throwable)e);
        }
    }

    public JBoss7DeploymentState getDeploymentStateSafe(String name) throws JBoss7ManangerException {
        if (!this.hasDeployment(name)) {
            return JBoss7DeploymentState.NOT_FOUND;
        }
        return this.getDeploymentState(name);
    }

    public JBoss7DeploymentState getDeploymentState(String name) throws JBoss7ManangerException {
        ModelNode request = new ModelNode();
        request.get("operation").set("read-resource");
        request.get("address").add("deployment", name);
        ModelNode result = null;
        try {
            result = this.execute(request);
        }
        catch (JBoss7ManangerException j7me) {
            return JBoss7DeploymentState.NOT_FOUND;
        }
        Boolean enabled = WildFly11ManagerUtil.getBooleanProperty("enabled", result);
        if (enabled == null) {
            throw new JBoss7ManangerException(NLS.bind((String)Messages.ModuleStateEvaluationFailed, (Object)name));
        }
        if (enabled.booleanValue()) {
            return JBoss7DeploymentState.STARTED;
        }
        return JBoss7DeploymentState.STOPPED;
    }

    public void stopServer() throws JBoss7ManangerException {
        ModelNode request = new ModelNode();
        request.get("operation").set("shutdown");
        this.quietlyExecute(request);
    }

    public JBoss7ServerState getServerState() throws JBoss7ManangerException {
        ModelNode request = new ModelNode();
        request.get("operation").set("read-attribute");
        request.get("name").set("server-state");
        ModelNode response = this.execute(request);
        return this.toJBoss7ServerState(response);
    }

    public boolean isRunning() {
        try {
            return this.getServerState() == JBoss7ServerState.RUNNING;
        }
        catch (Exception e) {
            return false;
        }
    }

    private JBoss7ServerState toJBoss7ServerState(ModelNode response) throws JBoss7ManangerException {
        try {
            return JBoss7ServerState.valueOfIgnoreCase((String)response.asString());
        }
        catch (IllegalArgumentException e) {
            throw new JBoss7ManangerException((Throwable)e);
        }
    }

    public void dispose() {
        if (this.client != null) {
            this.closeClient(this.client);
        }
    }

    private void closeClient(final ModelControllerClient client) {
        Thread t = new Thread("Closing client"){

            @Override
            public void run() {
                WildFly11Manager.this.closeClientJoin(client);
            }
        };
        t.start();
    }

    private void closeClientJoin(final ModelControllerClient client) {
        Runnable r = new Runnable(){

            @Override
            public void run() {
                try {
                    client.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        };
        Thread t = new Thread(r);
        try {
            try {
                t.start();
                t.join(5000L);
            }
            catch (InterruptedException interruptedException) {
                t.interrupt();
            }
        }
        finally {
            t.interrupt();
        }
    }

    ModelNode execute(ModelNode node) throws JBoss7ManangerException {
        try {
            ModelNode response = this.client.execute(node);
            if (!WildFly11ManagerUtil.isSuccess(response)) {
                throw new JBoss7ManangerException(NLS.bind((String)Messages.OperationOnAddressFailed, (Object[])new Object[]{node.get("operation"), node.get("address"), response.get("failure-description")}));
            }
            return response.get("result");
        }
        catch (Exception e) {
            throw new JBoss7ManangerException((Throwable)e);
        }
    }

    private void quietlyExecute(ModelNode node) throws JBoss7ManangerException {
        block2: {
            try {
                this.client.execute(node);
            }
            catch (Exception e) {
                if (this.isConnectionCloseException(e)) break block2;
                throw new JBoss7ManangerException((Throwable)e);
            }
        }
    }

    private boolean isConnectionCloseException(Exception e) {
        return e instanceof IOException && e.getMessage() != null && e.getMessage().indexOf("Channel closed") > -1 || e.getMessage().indexOf("Operation failed") > -1;
    }

    private IJBoss7DeploymentResult execute(DeploymentPlanBuilder builder) throws JBoss7ManangerException {
        try {
            DeploymentAction action = builder.getLastAction();
            DeploymentPlan plan = builder.build();
            Future planResult = this.manager.execute(plan);
            return new DeploymentOperationResult(action, planResult);
        }
        catch (Exception e) {
            throw new JBoss7ManangerException((Throwable)e);
        }
    }

    public static ModelNode getEmptyOperation(String operationName, ModelNode address) {
        ModelNode op = new ModelNode();
        op.get("operation").set(operationName);
        if (address != null) {
            op.get("address").set(address);
        } else {
            op.get("address");
        }
        return op;
    }

    public boolean hasDeployment(String name) throws JBoss7ManangerException {
        return this.getDeploymentNames().contains(name);
    }

    private Set<String> getDeploymentNames() throws JBoss7ManangerException {
        ModelNode op = WildFly11Manager.getEmptyOperation("read-children-names", new ModelNode());
        op.get("child-type").set("deployment");
        ModelNode result = this.execute(op);
        HashSet<String> deploymentNames = new HashSet<String>();
        if (result.isDefined()) {
            List deploymentNodes = result.asList();
            for (ModelNode node : deploymentNodes) {
                deploymentNames.add(node.asString());
            }
        }
        return deploymentNames;
    }

    public IJBoss7DeploymentResult incrementalPublish(IAS7ManagementDetails details, String deploymentName, IncrementalManagementModel model, boolean redeploy, IProgressMonitor monitor) throws JBoss7ManangerException {
        String[] children = model.getChildrenToExplode(deploymentName);
        this.explode(deploymentName, children);
        InitialDeploymentPlanBuilder b = this.manager.newDeploymentPlan();
        try {
            String[] deployments;
            String[] stringArray = deployments = model.getDeploymentIds();
            int n = deployments.length;
            int n2 = 0;
            while (n2 < n) {
                String deployment = stringArray[n2];
                Map changed = model.getChanged(deployment);
                List removed = model.getRemoved(deployment);
                if (changed.size() > 0 || removed.size() > 0) {
                    b = this.addChanges(deployment, changed, removed, (DeploymentPlanBuilder)b);
                }
                ++n2;
            }
            if (redeploy) {
                b = b.redeploy(deploymentName);
            }
            DeploymentAction action = b.getLastAction();
            DeploymentPlan plan = b.build();
            Future future = this.manager.execute(plan);
            DeploymentOperationResult res = new DeploymentOperationResult(action, future, 5000L, TimeUnit.MILLISECONDS);
            this.waitFor(res, "Incremental Deployment", (IProgressMonitor)new SubProgressMonitor(monitor, 95));
            return res;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new JBoss7ManangerException((Throwable)e);
        }
    }

    private DeploymentPlanBuilder addChanges(String deploymentName, Map<String, String> changedContent, List<String> removedContent, DeploymentPlanBuilder bd) throws IOException {
        HashMap<String, FileInputStream> addStreams = new HashMap<String, FileInputStream>();
        Iterator<String> changedIt = changedContent.keySet().iterator();
        ArrayList<String> failedChanges = new ArrayList<String>();
        while (changedIt.hasNext()) {
            String k = changedIt.next();
            String v = changedContent.get(k);
            try {
                addStreams.put(k, new FileInputStream(new File(v)));
            }
            catch (FileNotFoundException e) {
                failedChanges.add(k);
            }
        }
        if (addStreams.size() > 0) {
            bd = bd.addContentToDeployment(deploymentName, addStreams);
        }
        if (removedContent.size() > 0) {
            bd = bd.removeContenFromDeployment(deploymentName, removedContent);
        }
        return bd;
    }

    protected class ToolsWF11CallbackHandler
    implements CallbackHandler {
        private String realm;

        protected ToolsWF11CallbackHandler() {
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            if (callbacks.length == 2 && (callbacks[0] instanceof RealmCallback || callbacks[1] instanceof RealmCallback) && (callbacks[0] instanceof OptionalNameCallback || callbacks[1] instanceof OptionalNameCallback)) {
                return;
            }
            NameCallback nameCB = null;
            PasswordCallback passCB = null;
            CredentialCallback credCB = null;
            Callback[] callbackArray = callbacks;
            int n = callbacks.length;
            int n2 = 0;
            while (n2 < n) {
                Callback current = callbackArray[n2];
                if (current instanceof RealmCallback) {
                    RealmCallback rcb = (RealmCallback)current;
                    this.realm = rcb.getPrompt();
                    String defaultText = rcb.getDefaultText();
                    rcb.setText(defaultText);
                }
                if (current instanceof NameCallback) {
                    nameCB = (NameCallback)current;
                } else if (current instanceof PasswordCallback) {
                    passCB = (PasswordCallback)current;
                } else if (current instanceof CredentialCallback) {
                    credCB = (CredentialCallback)current;
                }
                ++n2;
            }
            if (nameCB instanceof OptionalNameCallback) {
                ((NameCallback)callbacks[0]).setName("anonymous JBossTools user");
                return;
            }
            String passPrompt = passCB == null ? "Password" : passCB.getPrompt();
            String[] results = WildFly11Manager.this.details.handleCallbacks(new String[]{nameCB.getPrompt(), passPrompt});
            if (results != null && results.length >= 2) {
                String u = results[0];
                String p = results[1];
                nameCB.setName(results[0]);
                if (passCB != null) {
                    passCB.setPassword(p.toCharArray());
                } else if (credCB != null) {
                    String digest = null;
                    if (digest == null && credCB.isCredentialTypeSupported(PasswordCredential.class, "clear")) {
                        credCB.setCredential((Credential)new PasswordCredential((Password)ClearPassword.createRaw((String)"clear", (char[])p.toCharArray())));
                    } else if (digest != null && credCB.isCredentialTypeSupported(PasswordCredential.class, "digest-md5")) {
                        byte[] bytes = CodePointIterator.ofString(digest).hexDecode().drain();
                        credCB.setCredential((Credential)new PasswordCredential((Password)DigestPassword.createRaw((String)"digest-md5", (String)u, (String)this.realm, (byte[])bytes)));
                    } else {
                        CallbackUtil.unsupported((Callback)credCB);
                    }
                }
            }
        }
    }
}

