/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.management.core;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class IncrementalManagementModel {
    private HashMap<String, Module> map = new HashMap();

    public void setDeploymentChanges(String deploymentId, Map<String, String> changedContent, List<String> removedContent) {
        Module m = new Module(changedContent, removedContent);
        this.map.put(deploymentId, m);
    }

    public void addSubDeploymentChanges(String deploymentId, String relative, Map<String, String> changedContent, List<String> removedContent) {
        Module m = this.map.get(deploymentId);
        if (m == null) {
            m = new Module(new HashMap<String, String>(), new ArrayList<String>());
            this.map.put(deploymentId, m);
        }
        Map<String, String> changes = m.changedContent;
        List<String> removed = m.removedContent;
        for (String k : changedContent.keySet()) {
            String v = changedContent.get(k);
            changes.put(String.valueOf(relative) + "/" + k, v);
        }
        Iterator<String> newRemoved = removedContent.iterator();
        while (newRemoved.hasNext()) {
            removed.add(String.valueOf(relative) + "/" + newRemoved.next());
        }
        m.toExplode.add(relative);
    }

    public String[] getChildrenToExplode(String deploymentId) {
        Module m = this.map.get(deploymentId);
        if (m == null) {
            return new String[0];
        }
        Set<String> s = m.toExplode;
        return s.toArray(new String[s.size()]);
    }

    public String[] getDeploymentIds() {
        Set<String> s = this.map.keySet();
        return s.toArray(new String[s.size()]);
    }

    public Map<String, String> getChanged(String deploymentId) {
        Module m = this.map.get(deploymentId);
        if (m != null) {
            return m.changedContent;
        }
        return null;
    }

    public List<String> getRemoved(String deploymentId) {
        Module m = this.map.get(deploymentId);
        if (m != null) {
            return m.removedContent;
        }
        return null;
    }

    private static class Module {
        Map<String, String> changedContent;
        List<String> removedContent;
        Set<String> toExplode;

        public Module(Map<String, String> changedContent, List<String> removedContent) {
            this.changedContent = changedContent;
            this.removedContent = removedContent;
            this.toExplode = new HashSet<String>();
        }
    }
}

