/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.management.core;

import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.management.core.AS7ManagementActivator;
import org.jboss.ide.eclipse.as.management.core.IJBoss7ManagerService;
import org.jboss.ide.eclipse.as.management.core.IJBossManagerServiceProvider;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManagerServiceProxy;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManangerException;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;

public class JBoss7ManagerUtil {
    public static IJBoss7ManagerService getService(IServer server) throws JBoss7ManangerException {
        String rtTypeId = null;
        if (server != null && server.getServerType() != null) {
            IRuntimeType rtt = server.getServerType().getRuntimeType();
            rtTypeId = rtt == null ? null : rtt.getId();
        }
        return JBoss7ManagerUtil.getService(rtTypeId);
    }

    public static IJBoss7ManagerService getManagerService(String serviceId) throws JBoss7ManangerException {
        try {
            BundleContext context = AS7ManagementActivator.getContext();
            JBoss7ManagerServiceProxy proxy = new JBoss7ManagerServiceProxy(context, serviceId);
            proxy.open();
            return proxy;
        }
        catch (InvalidSyntaxException ise) {
            throw new JBoss7ManangerException(ise);
        }
    }

    public static IJBoss7ManagerService getService(String runtimeType) throws JBoss7ManangerException {
        IJBossManagerServiceProvider serviceProvider = JBoss7ManagerUtil.getServiceProvider(runtimeType);
        return serviceProvider == null ? null : serviceProvider.getManagerService();
    }

    public static String getRequiredVersion(IServer server) {
        String id = server.getRuntime().getRuntimeType().getId();
        return JBoss7ManagerUtil.getRequiredServiceVersion(id);
    }

    public static String getRequiredServiceVersion(String runtimeType) {
        IJBossManagerServiceProvider serviceProvider = JBoss7ManagerUtil.getServiceProvider(runtimeType);
        return serviceProvider == null ? null : serviceProvider.getManagerServiceId();
    }

    protected static IJBossManagerServiceProvider getServiceProvider(String runtimeType) {
        IRuntimeType rtType;
        if (runtimeType != null && (rtType = ServerCore.findRuntimeType((String)runtimeType)) != null) {
            IJBossManagerServiceProvider serviceProvider = (IJBossManagerServiceProvider)Platform.getAdapterManager().getAdapter((Object)rtType, IJBossManagerServiceProvider.class);
            return serviceProvider;
        }
        return null;
    }

    public static void dispose(IJBoss7ManagerService service) {
        if (service != null) {
            service.dispose();
        }
    }

    public static <RESULT> RESULT executeWithService(IServiceAware<RESULT> serviceAware, IServer server) throws Exception {
        IJBoss7ManagerService service = null;
        try {
            service = JBoss7ManagerUtil.getService(server);
            RESULT RESULT = serviceAware.execute(service);
            return RESULT;
        }
        finally {
            if (service != null) {
                service.dispose();
            }
        }
    }

    public static interface IServiceAware<RESULT> {
        public RESULT execute(IJBoss7ManagerService var1) throws Exception;
    }
}

