/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.local.internal.ui;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.graphics.Image;
import org.jboss.tools.jmx.jvmmonitor.core.IActiveJvm;
import org.jboss.tools.jmx.local.internal.Activator;
import org.jboss.tools.jmx.local.internal.JmxLocalExtensionManager;
import org.jboss.tools.jmx.local.internal.JvmConnectionWrapper;
import org.jboss.tools.jmx.local.ui.JVMLabelProviderDelegate;

public class JVMConnectionLabelProvider
extends LabelProvider
implements ILabelProvider {
    protected static final Map<String, String> vmAliasMap = new HashMap<String, String>();
    private JVMLabelProviderDelegate[] jvmConnectionLabelProviders = JmxLocalExtensionManager.getDefault().getJvmConnectionLabelProviders();

    static {
        vmAliasMap.put("com.intellij.rt.execution.application.AppMain", "idea");
        vmAliasMap.put("org.jetbrains.idea.maven.server.RemoteMavenServer", "idea maven server");
        vmAliasMap.put("scala.tools.nsc.MainGenericRunner", "scala repl");
    }

    private JVMLabelProviderDelegate findProvider(IActiveJvm jvm) {
        int i = 0;
        while (i < this.jvmConnectionLabelProviders.length) {
            if (this.jvmConnectionLabelProviders[i].accepts(jvm)) {
                return this.jvmConnectionLabelProviders[i];
            }
            ++i;
        }
        return null;
    }

    static String getNameFromAliasMap(String displayName) {
        Set<Map.Entry<String, String>> entrySet = vmAliasMap.entrySet();
        for (Map.Entry<String, String> entry : entrySet) {
            String key = entry.getKey();
            if (!displayName.startsWith(key)) continue;
            return String.valueOf(entry.getValue()) + displayName.substring(key.length());
        }
        return displayName;
    }

    public Image getImage(Object element) {
        Image ret = null;
        if (element instanceof JvmConnectionWrapper) {
            IActiveJvm activeJvm = ((JvmConnectionWrapper)element).getActiveJvm();
            JVMLabelProviderDelegate provider = this.findProvider(activeJvm);
            if (provider != null) {
                ret = provider.getImage(activeJvm);
            }
            if (ret == null) {
                ret = Activator.getDefault().getSharedImages().image("image/container.gif");
            }
        }
        return ret;
    }

    public String getText(Object element) {
        if (element instanceof JvmConnectionWrapper) {
            String displayName;
            IActiveJvm activeJvm = ((JvmConnectionWrapper)element).getActiveJvm();
            JVMLabelProviderDelegate provider = this.findProvider(activeJvm);
            if (provider != null) {
                displayName = provider.getDisplayString(activeJvm);
            } else {
                displayName = activeJvm.getMainClass();
                displayName = JVMConnectionLabelProvider.getNameFromAliasMap(displayName);
            }
            displayName = String.valueOf(displayName) + " [" + activeJvm.getPid() + "]";
            return displayName;
        }
        return null;
    }
}

