/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.management.itests;

import java.util.ArrayList;
import java.util.Collection;
import junit.framework.Assert;
import org.jboss.ide.eclipse.as.management.core.IJBoss7ManagerService;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManagerServiceProxy;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManagerUtil;
import org.jboss.tools.as.test.core.internal.utils.MatrixUtils;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.osgi.util.tracker.ServiceTracker;

@RunWith(value=Parameterized.class)
public class AS7ManagementServiceResolutionTest
extends Assert {
    private String serviceId;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList l = MatrixUtils.toMatrix((Object[][])new Object[][]{IJBoss7ManagerService.ALL_SERVICE_VERSIONS});
        return l;
    }

    public AS7ManagementServiceResolutionTest(String serviceId) {
        this.serviceId = serviceId;
    }

    @Test
    public void verifyCorrectService() {
        AS7ManagementServiceResolutionTest.assertNotNull((Object)this.serviceId);
        IJBoss7ManagerService service = JBoss7ManagerUtil.getManagerService((String)this.serviceId);
        AS7ManagementServiceResolutionTest.assertNotNull((String)("Management Service with version " + this.serviceId + " not found."), (Object)service);
        AS7ManagementServiceResolutionTest.assertTrue((boolean)(service instanceof JBoss7ManagerServiceProxy));
        AS7ManagementServiceResolutionTest.assertTrue((boolean)(service instanceof ServiceTracker));
        Object o = ((ServiceTracker)service).getService();
        AS7ManagementServiceResolutionTest.assertNotNull((String)("Service not found for version " + this.serviceId), (Object)o);
    }
}

