/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.management.itests;

import java.util.ArrayList;
import java.util.Collection;
import junit.framework.Assert;
import org.eclipse.core.runtime.Path;
import org.jboss.ide.eclipse.as.management.core.IJBoss7ManagerService;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManagerServiceProxy;
import org.jboss.tools.as.management.itests.utils.AS7ManagerTestUtils;
import org.jboss.tools.as.management.itests.utils.ParameterUtils;
import org.jboss.tools.as.management.itests.utils.StartupUtility;
import org.jboss.tools.as.test.core.internal.utils.MatrixUtils;
import org.junit.AfterClass;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.osgi.util.tracker.ServiceTracker;

@RunWith(value=Parameterized.class)
public class AS7ManagementServiceStartupShutdownTest
extends Assert {
    private static StartupUtility util;
    private String homeDir;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList l = MatrixUtils.toMatrix((Object[][])new Object[][]{ParameterUtils.getAS7ServerHomes()});
        return l;
    }

    @BeforeClass
    public static void init() {
        util = new StartupUtility();
    }

    @AfterClass
    public static void cleanup() {
        util.dispose();
    }

    public AS7ManagementServiceStartupShutdownTest(String home) {
        this.homeDir = home;
        System.out.println(String.valueOf(((Object)((Object)this)).getClass().getName()) + ":  " + this.homeDir);
    }

    @Before
    public void before() {
        AS7ManagementServiceStartupShutdownTest.assertNotNull((Object)this.homeDir);
        AS7ManagementServiceStartupShutdownTest.assertTrue((boolean)new Path(this.homeDir).toFile().exists());
        String rtType = ParameterUtils.serverHomeToRuntimeType.get(this.homeDir);
        AS7ManagementServiceStartupShutdownTest.assertNotNull((Object)rtType);
        IJBoss7ManagerService service = AS7ManagerTestUtils.findService(rtType);
        AS7ManagementServiceStartupShutdownTest.assertNotNull((String)("Management Service for runtime type " + rtType + " not found."), (Object)service);
        AS7ManagementServiceStartupShutdownTest.assertTrue((boolean)(service instanceof JBoss7ManagerServiceProxy));
        AS7ManagementServiceStartupShutdownTest.assertTrue((boolean)(service instanceof ServiceTracker));
        Object o = ((ServiceTracker)service).getService();
        AS7ManagementServiceStartupShutdownTest.assertNotNull((Object)o);
        String hd2 = util.getHomeDir();
        if (!this.homeDir.equals(hd2)) {
            util.dispose();
            util.setHomeDir(this.homeDir);
            util.start(true);
        }
    }

    @Test
    public void dummyTest() {
    }
}

