/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.management.itests.utils;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.Socket;
import java.net.SocketException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.UnknownHostException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.core.server.v7.management.AS7ManagementDetails;
import org.jboss.ide.eclipse.as.management.core.IAS7ManagementDetails;
import org.jboss.ide.eclipse.as.management.core.IJBoss7DeploymentResult;
import org.jboss.ide.eclipse.as.management.core.IJBoss7ManagerService;
import org.jboss.ide.eclipse.as.management.core.IJBossManagerServiceProvider;
import org.jboss.ide.eclipse.as.management.core.JBoss7ManangerException;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleException;

public class AS7ManagerTestUtils {
    public static final String GWT_HELLOWORLD_WAR = "gwt-helloworld.war";
    public static final String MINIMALISTIC_WAR = "minimalistic.war";
    public static final String LOCALHOST = "localhost";
    public static final int WEB_PORT = 8080;
    public static final int MGMT_PORT = 9999;
    private static final String WAR_FOLDER = "/wars/";
    private static final int RESPONSE_TIMEOUT = 10240;
    private static final long WAIT_TIMEOUT = 10240L;

    private AS7ManagerTestUtils() {
    }

    public static File getWarFile(String name) throws URISyntaxException, IOException {
        Bundle bundle = Platform.getBundle((String)"org.jboss.tools.as.management.itests");
        URL entryUrl = bundle.getEntry(WAR_FOLDER + name);
        return new File(FileLocator.resolve((URL)entryUrl).toURI());
    }

    public static String waitForRespose(String name, String host, int port) throws IOException {
        HttpURLConnection response1 = AS7ManagerTestUtils.waitForResponseCode(200, name, host, port);
        response1.disconnect();
        String result = AS7ManagerTestUtils.getResponse(name, host, port);
        return result;
    }

    public static void quietlyUndeploy(String name, IJBoss7ManagerService manager, IAS7ManagementDetails details) {
        try {
            AS7ManagerTestUtils.waitUntilFinished(manager.undeploySync(details, name, true, (IProgressMonitor)new NullProgressMonitor()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void quietlyRemove(String name, IJBoss7ManagerService manager, IAS7ManagementDetails details) {
        try {
            AS7ManagerTestUtils.waitUntilFinished(manager.removeDeployment(details, name, (IProgressMonitor)new NullProgressMonitor()));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static void waitUntilFinished(IJBoss7DeploymentResult result) throws JBoss7ManangerException {
        result.getStatus();
    }

    public static String getResponse(String name, String host, int port) throws IOException {
        URL url = new URL("http://" + host + ":" + port + "/" + name);
        HttpURLConnection connection = AS7ManagerTestUtils.connect(url);
        String s = AS7ManagerTestUtils.toString(new BufferedInputStream(connection.getInputStream()));
        connection.disconnect();
        return s;
    }

    public static HttpURLConnection waitForResponseCode(int code, String name, String host, int port) throws IOException {
        URL url = new URL("http://" + host + ":" + port + "/" + name);
        long until = System.currentTimeMillis() + 10240L;
        int resetCount = 0;
        while (System.currentTimeMillis() < until) {
            HttpURLConnection connection = AS7ManagerTestUtils.connect(url);
            try {
                if (connection.getResponseCode() != code) continue;
                HttpURLConnection httpURLConnection = connection;
                return httpURLConnection;
            }
            catch (FileNotFoundException e) {
                if (code == 404) {
                    HttpURLConnection httpURLConnection = connection;
                    return httpURLConnection;
                }
                throw e;
            }
            catch (SocketException se) {
                if (++resetCount < 10) continue;
                throw se;
            }
            finally {
                connection.disconnect();
            }
        }
        throw new RuntimeException("wait on url " + url + " for response code " + code + " timed out.");
    }

    private static HttpURLConnection connect(URL url) throws IOException {
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setUseCaches(false);
        connection.setDoInput(true);
        connection.setAllowUserInteraction(false);
        connection.setConnectTimeout(10240);
        connection.setInstanceFollowRedirects(true);
        connection.setDoOutput(false);
        return connection;
    }

    public static String toString(InputStream in) throws IOException {
        StringWriter writer = new StringWriter();
        int data = -1;
        while ((data = in.read()) != -1) {
            writer.write(data);
        }
        return writer.toString();
    }

    public static boolean isListening(String host, int port) throws UnknownHostException, IOException {
        try (Socket socket = null;){
            socket = new Socket(host, port);
            boolean bl = socket.isConnected();
            return bl;
        }
    }

    public static IAS7ManagementDetails createStandardDetails() {
        return new MockAS7ManagementDetails(LOCALHOST, 9999);
    }

    public static IJBoss7ManagerService findService(String runtimeType) {
        return AS7ManagerTestUtils.findService(ServerCore.findRuntimeType((String)runtimeType));
    }

    public static IJBoss7ManagerService findService(IRuntimeType runtimeType) {
        AS7ManagerTestUtils.forceStart("org.jboss.ide.eclipse.as.core");
        AS7ManagerTestUtils.forceStart("org.jboss.ide.eclipse.as.management.as7");
        AS7ManagerTestUtils.forceStart("org.jboss.ide.eclipse.as.management.wildfly9");
        IJBossManagerServiceProvider serviceProvider = (IJBossManagerServiceProvider)Platform.getAdapterManager().getAdapter((Object)runtimeType, IJBossManagerServiceProvider.class);
        if (serviceProvider != null) {
            return serviceProvider.getManagerService();
        }
        return null;
    }

    private static boolean forceStart(String bundleId) {
        Bundle bundle = Platform.getBundle((String)bundleId);
        if (bundle != null && bundle.getState() != 32) {
            try {
                bundle.start();
            }
            catch (BundleException bundleException) {
                // empty catch block
            }
        }
        return bundle.getState() == 32;
    }

    public static class MockAS7ManagementDetails
    extends AS7ManagementDetails {
        private String host;
        private int port;

        public MockAS7ManagementDetails(String host, int port) {
            super(null);
            this.host = host;
            this.port = port;
        }

        public String getHost() {
            return this.host;
        }

        public int getManagementPort() {
            return this.port;
        }

        public String[] handleCallbacks(String[] prompts) throws UnsupportedOperationException {
            return new String[0];
        }
    }
}

