/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.server.IDelegatingServerBehavior;
import org.jboss.ide.eclipse.as.core.server.IPollResultListener;
import org.jboss.ide.eclipse.as.core.server.IServerModuleStateVerifier;
import org.jboss.ide.eclipse.as.core.server.IServerStatePoller;
import org.jboss.ide.eclipse.as.core.server.internal.AbstractBehaviourDelegate;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.server.internal.PollThread;
import org.jboss.ide.eclipse.as.core.server.internal.UpdateModuleStateJob;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.JBossExtendedProperties;
import org.jboss.ide.eclipse.as.core.util.LaunchCommandPreferences;
import org.jboss.ide.eclipse.as.core.util.PollThreadUtils;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;

public abstract class AbstractJBossBehaviourDelegate
extends AbstractBehaviourDelegate {
    private PollThread pollThread = null;

    protected PollThread getPollThread() {
        return this.pollThread;
    }

    public IServer getServer() {
        return this.actualBehavior.getServer();
    }

    @Override
    public void stop(boolean force) {
        JBossExtendedProperties properties;
        boolean ignoreLaunch = false;
        ignoreLaunch = LaunchCommandPreferences.isIgnoreLaunchCommand((IServerAttributes)this.getServer());
        if (ignoreLaunch) {
            this.actualBehavior.setServerStopped();
            return;
        }
        boolean removeScanners = this.getServer().getAttribute("org.jboss.ide.eclipse.as.core.server.removeDeploymentScanner", true);
        if (removeScanners && (properties = (JBossExtendedProperties)this.getServer().loadAdapter(JBossExtendedProperties.class, null)) != null) {
            properties.getDeploymentScannerModifier().removeAddedDeploymentScanners(this.getServer());
        }
        this.stopImpl(force);
    }

    protected abstract void stopImpl(boolean var1);

    protected abstract void forceStop();

    protected abstract IStatus gracefullStop();

    @Override
    public IStatus canChangeState(String launchMode) {
        return Status.OK_STATUS;
    }

    @Override
    public String getDefaultStopArguments() throws CoreException {
        JBossServer jbs = (JBossServer)ServerConverter.getJBossServer((IServer)this.getServer());
        return jbs.getExtendedProperties().getDefaultLaunchArguments().getDefaultStopArgs();
    }

    protected void pollServer(boolean expectedState) {
        IServerStatePoller poller = PollThreadUtils.getPoller(expectedState, this.getServer());
        this.pollServer(expectedState, poller);
    }

    protected void pollServer(boolean expectedState, IServerStatePoller poller) {
        this.stopPolling();
        this.pollThread = PollThreadUtils.pollServer(expectedState, poller, this.pollThread, this.onPollingFinished(), this.getServer());
    }

    protected IPollResultListener onPollingFinished() {
        return new IPollResultListener(){

            public void stateNotAsserted(boolean expectedState, boolean currentState) {
                AbstractJBossBehaviourDelegate.this.stop(true);
            }

            public void stateAsserted(boolean expectedState, boolean currentState) {
                if (currentState) {
                    AbstractJBossBehaviourDelegate.this.getActualBehavior().setServerStarted();
                } else {
                    AbstractJBossBehaviourDelegate.this.getActualBehavior().setServerStopped();
                }
            }
        };
    }

    protected void stopPolling() {
        this.cancelPolling(null);
    }

    protected void cancelPolling(String message) {
        PollThreadUtils.cancelPolling(message, this.pollThread);
        this.pollThread = null;
    }

    protected IDelegatingServerBehavior getActualBehavior() {
        return this.actualBehavior;
    }

    @Override
    public void onServerStarted() {
        IServer s = this.getActualBehavior().getServer();
        JBossExtendedProperties properties = (JBossExtendedProperties)s.loadAdapter(JBossExtendedProperties.class, null);
        if (properties != null) {
            Job rootJob;
            Job scannerJob = properties.getDeploymentScannerModifier().getUpdateDeploymentScannerJob(s);
            IServerModuleStateVerifier verifier = properties.getModuleStateVerifier();
            UpdateModuleStateJob moduleStateJob = null;
            if (verifier != null) {
                moduleStateJob = new UpdateModuleStateJob(s, verifier);
            }
            if ((rootJob = this.chainJobs(scannerJob, moduleStateJob)) != null) {
                rootJob.schedule();
            }
        }
    }

    private Job chainJobs(final Job job1, final Job job2) {
        if (job1 == null) {
            return job2;
        }
        if (job2 == null) {
            return job1;
        }
        JobChangeAdapter listener = new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                job1.removeJobChangeListener((IJobChangeListener)this);
                if (job2 != null && event.getResult() != null && event.getResult().getSeverity() != 4 && event.getResult().getSeverity() != 8) {
                    job2.schedule();
                }
            }
        };
        job1.addJobChangeListener((IJobChangeListener)listener);
        return job1;
    }

    @Deprecated
    protected void setServerStopping() {
        this.getActualBehavior().setServerStopping();
    }

    @Deprecated
    protected void setServerStopped() {
        this.getActualBehavior().setServerStopped();
    }

    @Deprecated
    protected void setServerStarted() {
        this.getActualBehavior().setServerStarted();
    }

    @Deprecated
    protected void setServerStarting() {
        this.getActualBehavior().setServerStarting();
    }
}

