/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal.v7;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.jboss.ide.eclipse.as.core.server.IServerModuleStateVerifier;
import org.jboss.ide.eclipse.as.core.server.internal.v7.AbstractJBoss7ModuleStateVerifier;
import org.jboss.ide.eclipse.as.core.server.internal.v7.DeploymentMarkerUtils;
import org.jboss.ide.eclipse.as.core.util.RemotePath;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IFilesystemController;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.IModuleStateController;
import org.jboss.tools.as.core.server.controllable.systems.IDeploymentOptionsController;
import org.jboss.tools.as.core.server.controllable.systems.IModuleDeployPathController;

public class JBoss7FSModuleStateVerifier
extends AbstractJBoss7ModuleStateVerifier
implements IModuleStateController,
IServerModuleStateVerifier {
    private IDeploymentOptionsController deploymentOptions;
    private IModuleDeployPathController deployPathController;
    private IFilesystemController filesystemController;

    protected IFilesystemController getFilesystemController() throws CoreException {
        if (this.filesystemController == null) {
            this.filesystemController = (IFilesystemController)this.findDependencyFromBehavior("filesystem");
        }
        return this.filesystemController;
    }

    private IPath getModuleDeployRoot(IModule[] module) throws CoreException {
        IDeploymentOptionsController opts = this.getDeploymentOptions();
        IModuleDeployPathController depPath = this.getDeployPathController();
        return new RemotePath(depPath.getDeployDirectory(module).toOSString(), opts.getPathSeparatorCharacter());
    }

    protected IDeploymentOptionsController getDeploymentOptions() throws CoreException {
        if (this.deploymentOptions == null) {
            this.deploymentOptions = (IDeploymentOptionsController)this.findDependencyFromBehavior("deploymentOptions");
        }
        return this.deploymentOptions;
    }

    protected IModuleDeployPathController getDeployPathController() throws CoreException {
        if (this.deployPathController == null) {
            this.deployPathController = (IModuleDeployPathController)this.findDependencyFromBehavior("moduleDeployPath");
        }
        return this.deployPathController;
    }

    @Override
    protected int getRootModuleState(IServer server, IModule root, String deploymentName, IProgressMonitor monitor) throws Exception {
        IFilesystemController c = this.getFilesystemController();
        IPath d = this.getModuleDeployRoot(new IModule[]{root});
        if (DeploymentMarkerUtils.markerExists(d, c, ".deployed")) {
            return 2;
        }
        if (DeploymentMarkerUtils.markerExists(d, c, ".isdeploying")) {
            return 1;
        }
        if (DeploymentMarkerUtils.markerExists(d, c, ".failed")) {
            return 4;
        }
        if (DeploymentMarkerUtils.markerExists(d, c, ".pending")) {
            return 1;
        }
        if (DeploymentMarkerUtils.markerExists(d, c, ".skipdeploy")) {
            return 4;
        }
        if (DeploymentMarkerUtils.markerExists(d, c, ".undeployed")) {
            return 4;
        }
        if (DeploymentMarkerUtils.markerExists(d, c, ".isundeploying")) {
            return 3;
        }
        return 0;
    }

    @Override
    public int changeModuleStateTo(IModule[] module, int state, IProgressMonitor monitor) throws CoreException {
        IPath archiveDestination = this.getModuleDeployRoot(new IModule[]{module[0]});
        if (state == 2) {
            DeploymentMarkerUtils.removedUndeployedMarker(archiveDestination, this.getFilesystemController());
            DeploymentMarkerUtils.createDoDeployMarker(archiveDestination, this.getFilesystemController());
        } else if (state == 4) {
            DeploymentMarkerUtils.removedDeployedMarker(archiveDestination, this.getFilesystemController());
        } else {
            throw new IllegalArgumentException("Only states IServer.STATE_STARTED and IServer.STATE_STOPPED are supported");
        }
        return state;
    }
}

