/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.core.server.internal.v7;

import java.net.MalformedURLException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.jdt.launching.IRuntimeClasspathEntry;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.jboss.ide.eclipse.as.core.server.IDefaultClasspathLaunchConfigurator;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;
import org.jboss.ide.eclipse.as.core.server.internal.JBossServer;
import org.jboss.ide.eclipse.as.core.server.internal.launch.configuration.AbstractStartLaunchConfigurator;
import org.jboss.ide.eclipse.as.core.server.internal.v7.JBoss7LaunchConfigProperties;
import org.jboss.ide.eclipse.as.core.server.internal.v7.LocalJBoss7ServerRuntime;
import org.jboss.ide.eclipse.as.core.util.IJBossRuntimeResourceConstants;
import org.jboss.ide.eclipse.as.core.util.LaunchCommandPreferences;
import org.jboss.ide.eclipse.as.core.util.LaunchConfigUtils;
import org.jboss.ide.eclipse.as.core.util.ServerUtil;

public class LocalJBoss7StartConfigurator
extends AbstractStartLaunchConfigurator
implements IDefaultClasspathLaunchConfigurator {
    private JBoss7LaunchConfigProperties properties = null;

    public LocalJBoss7StartConfigurator(IServer server) throws CoreException {
        super(server);
    }

    @Override
    protected JBoss7LaunchConfigProperties getProperties() {
        if (this.properties == null) {
            this.properties = this.createProperties();
        }
        return this.properties;
    }

    @Override
    protected JBoss7LaunchConfigProperties createProperties() {
        return new JBoss7LaunchConfigProperties();
    }

    @Override
    protected void doOverrides(ILaunchConfigurationWorkingCopy launchConfig) throws CoreException {
        JBossServer jbossServer = this.getJBossServer();
        IJBossServerRuntime jbossRuntime = this.getJBossRuntime();
        this.getProperties().setHost(this.getHost(jbossServer, jbossRuntime), launchConfig);
        this.getProperties().setServerHome(this.getServerHome(jbossRuntime), jbossRuntime, launchConfig);
        this.getProperties().setServerFlag(this.getSupportsServerFlag(jbossRuntime), jbossRuntime, launchConfig);
        this.getProperties().setJreContainer(this.getJreContainerPath(jbossRuntime), launchConfig);
        this.getProperties().setEndorsedDir(this.getEndorsedDir(jbossRuntime), launchConfig);
        this.getProperties().setJavaLibPath(this.getJavaLibraryPath(jbossRuntime), launchConfig);
        this.getProperties().setExposedManagement(this.getExposedManagement(jbossServer), launchConfig);
        this.getProperties().setWorkingDirectory(this.getWorkingDirectory(), launchConfig);
        this.getProperties().setClasspathProvider(this.getClasspathProvider(), launchConfig);
        this.getProperties().setClasspath(this.getClasspath(this.getProperties().getClasspath((ILaunchConfiguration)launchConfig)), launchConfig);
        this.getProperties().setUseDefaultClassPath(this.isUseDefaultClasspath(), launchConfig);
        this.getProperties().setServerId(this.getServerId(this.server), launchConfig);
        this.getProperties().setModulesFolder(this.getModulesFolder(jbossServer, jbossRuntime), launchConfig);
        this.getProperties().setConfigurationFile(this.getServerConfigFile(jbossServer, jbossRuntime), launchConfig);
        this.getProperties().setBaseDirectory(this.getBaseDir(jbossRuntime), launchConfig);
        this.getProperties().setBootLogFile(this.getBootLogPath(jbossRuntime), launchConfig);
        this.getProperties().setLoggingConfigFile(this.getLoggingConfigPath(jbossRuntime), launchConfig);
        this.getProperties().setPreferIP4(this.getPreferIP4(this.server.getHost()), launchConfig);
    }

    @Override
    protected String getMainType() {
        return "org.jboss.modules.Main";
    }

    @Override
    protected String getWorkingDirectory() throws CoreException {
        return this.runtime.getLocation().append("bin").toString();
    }

    protected String getModulesFolder(JBossServer server, IJBossServerRuntime runtime) throws CoreException {
        return runtime.getRuntime().getLocation().append("modules").toString();
    }

    protected String getServerConfigFile(JBossServer server, IJBossServerRuntime runtime) throws CoreException {
        LocalJBoss7ServerRuntime rt = (LocalJBoss7ServerRuntime)((Object)runtime.getRuntime().loadAdapter(LocalJBoss7ServerRuntime.class, null));
        return rt.getConfigurationFile();
    }

    protected String getBaseDir(IJBossServerRuntime runtime) throws CoreException {
        LocalJBoss7ServerRuntime rt = (LocalJBoss7ServerRuntime)((Object)runtime.getRuntime().loadAdapter(LocalJBoss7ServerRuntime.class, null));
        return rt.getBaseDirectory();
    }

    public IRuntimeClasspathEntry[] getDefaultClasspathEntries(ILaunchConfiguration config) throws CoreException {
        IVMInstall vmInstall = this.getJBossRuntime().getVM();
        IRuntimeClasspathEntry modulesEntry = LaunchConfigUtils.getModulesClasspathEntry(this.server);
        IRuntimeClasspathEntry jreEntry = LaunchConfigUtils.getJREEntry(vmInstall);
        return new IRuntimeClasspathEntry[]{jreEntry, modulesEntry};
    }

    @Override
    protected List<String> getClasspath(List<String> currentClasspath) throws CoreException {
        IVMInstall vmInstall = this.getJBossRuntime().getVM();
        IRuntimeClasspathEntry modulesEntry = LaunchConfigUtils.getModulesClasspathEntry(this.server);
        IRuntimeClasspathEntry jreEntry = LaunchConfigUtils.getJREEntry(vmInstall);
        String modulesMemento = modulesEntry == null ? null : modulesEntry.getMemento();
        String jreMemento = jreEntry == null ? null : jreEntry.getMemento();
        Iterator<String> i = currentClasspath.iterator();
        String t = null;
        while (i.hasNext()) {
            t = i.next();
            if (!t.contains("org.eclipse.jdt.launching.JRE_CONTAINER/")) continue;
            i.remove();
        }
        ArrayList<String> classpath = new ArrayList<String>();
        classpath.addAll(currentClasspath);
        if (modulesMemento != null && !classpath.contains(modulesMemento)) {
            classpath.add(modulesMemento);
        }
        if (jreMemento != null && !classpath.contains(jreMemento)) {
            classpath.add(jreMemento);
        }
        return classpath;
    }

    @Override
    protected String getHost(JBossServer server, IJBossServerRuntime runtime) {
        if (LaunchCommandPreferences.listensOnAllHosts((IServerAttributes)server.getServer())) {
            return "0.0.0.0";
        }
        return server.getHost();
    }

    protected String getExposedManagement(JBossServer server) {
        if (LaunchCommandPreferences.exposesManagement((IServerAttributes)server.getServer())) {
            return server.getHost();
        }
        return null;
    }

    @Override
    protected String getDefaultProgramArguments() {
        return this.getJBossServer().getExtendedProperties().getDefaultLaunchArguments().getStartDefaultProgramArgs();
    }

    @Override
    protected String getServerHome(IJBossServerRuntime runtime) {
        return runtime.getRuntime().getLocation().toString();
    }

    @Override
    protected String getServerConfig(IJBossServerRuntime runtime) {
        return null;
    }

    @Override
    protected String getEndorsedDir(IJBossServerRuntime runtime) {
        return null;
    }

    @Override
    protected String getJavaLibraryPath(IJBossServerRuntime runtime) {
        return null;
    }

    protected String getBootLogPath(IJBossServerRuntime runtime) {
        IJBossRuntimeResourceConstants c = new IJBossRuntimeResourceConstants(){};
        Path basedir = new Path(((LocalJBoss7ServerRuntime)runtime).getBaseDirectory());
        IPath bootLog = basedir.append("log").append("boot.log");
        return bootLog.toString();
    }

    protected String getLoggingConfigPath(IJBossServerRuntime runtime) {
        IJBossRuntimeResourceConstants c = new IJBossRuntimeResourceConstants(){};
        Path basedir = new Path(((LocalJBoss7ServerRuntime)runtime).getBaseDirectory());
        IPath logConfigPath = basedir.append("configuration").append("logging.properties");
        try {
            return logConfigPath.toFile().toURI().toURL().toString();
        }
        catch (MalformedURLException murle) {
            return null;
        }
    }

    protected boolean getPreferIP4(String host) {
        boolean matches6 = ServerUtil.matchesIP6t(host);
        return !matches6;
    }
}

