/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.core.internal.modules;

import java.util.HashMap;
import org.eclipse.wst.server.core.IModule;
import org.jboss.tools.as.core.internal.modules.DeploymentModulePrefs;
import org.jboss.tools.foundation.core.xml.IMemento;

public class DeploymentTypePrefs {
    private static final String MODULE = "module";
    private static final String ID = "id";
    private static final String PROPERTY = "property";
    private static final String KEY = "key";
    private static final String VALUE = "value";
    private HashMap<String, DeploymentModulePrefs> children;
    private IMemento memento;

    public DeploymentTypePrefs(IMemento memento) {
        this.memento = memento;
        this.children = new HashMap();
        IMemento[] mementos = memento.getChildren(MODULE);
        int i = 0;
        while (i < mementos.length) {
            String id = mementos[i].getString(ID);
            this.children.put(id, new DeploymentModulePrefs(mementos[i]));
            ++i;
        }
    }

    public DeploymentModulePrefs getModulePrefs(IModule module) {
        return this.getModulePrefs(module.getId());
    }

    public DeploymentModulePrefs getModulePrefs(String id) {
        return this.children.get(id);
    }

    public DeploymentModulePrefs getOrCreateModulePrefs(IModule module) {
        return this.getOrCreateModulePrefs(module.getId());
    }

    public DeploymentModulePrefs getOrCreateModulePrefs(String id) {
        if (this.children.get(id) == null) {
            IMemento childMemento = this.memento.createChild(MODULE);
            childMemento.putString(ID, id);
            this.children.put(id, new DeploymentModulePrefs(childMemento));
        }
        return this.children.get(id);
    }

    public String getProperty(String key) {
        IMemento[] children = this.memento.getChildren(PROPERTY);
        int i = 0;
        while (i < children.length) {
            if (key.equals(children[i].getString(KEY))) {
                return children[i].getString(VALUE);
            }
            ++i;
        }
        return null;
    }

    public void setProperty(String key, String val) {
        IMemento[] children = this.memento.getChildren(PROPERTY);
        int i = 0;
        while (i < children.length) {
            if (key.equals(children[i].getString(KEY))) {
                children[i].putString(KEY, key);
                children[i].putString(VALUE, val);
                return;
            }
            ++i;
        }
        IMemento child = this.memento.createChild(PROPERTY);
        child.putString(KEY, key);
        child.putString(VALUE, val);
    }
}

