/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.core.server.controllable.subsystems.internal;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IModule;
import org.jboss.ide.eclipse.as.core.extensions.events.ServerLogger;
import org.jboss.ide.eclipse.as.core.server.IModulePathFilter;
import org.jboss.ide.eclipse.as.core.server.internal.v7.DeploymentMarkerUtils;
import org.jboss.ide.eclipse.as.core.util.ServerHomeValidationUtility;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.LocalFilesystemController;
import org.jboss.tools.as.core.server.controllable.subsystems.internal.StandardFileSystemPublishController;

public class WildFlyFileSystemPublishController
extends StandardFileSystemPublishController {
    @Override
    protected int removeModule(IModule[] module, IPath remote, IProgressMonitor monitor) throws CoreException {
        boolean undeploySucceeded = this.undeployModuleAndWait(module, remote, 45000, monitor);
        if (!undeploySucceeded) {
            ServerLogger.getDefault().log(this.getServer(), (IStatus)new Status(2, "org.jboss.ide.eclipse.as.core", NLS.bind((String)"Safely halting deployment {0} on server {1} before publish has failed.", (Object)module[0].getName(), (Object)this.getServer().getName())));
        }
        return super.removeModule(module, remote, monitor);
    }

    @Override
    protected IStatus[] executeFullPublish(IModule[] module, IPath archiveDestination, IModulePathFilter filter, IProgressMonitor monitor) throws CoreException {
        boolean undeploySucceeded = this.undeployModuleAndWait(module, archiveDestination, 45000, monitor);
        if (!undeploySucceeded) {
            ServerLogger.getDefault().log(this.getServer(), (IStatus)new Status(2, "org.jboss.ide.eclipse.as.core", NLS.bind((String)"Safely halting deployment {0} on server {1} before publish has failed.", (Object)module[0].getName(), (Object)this.getServer().getName())));
        }
        return super.executeFullPublish(module, archiveDestination, filter, monitor);
    }

    protected boolean undeployModuleAndWait(IModule[] module, IPath remote, int maxWait, IProgressMonitor monitor) throws CoreException {
        if (module.length > 1) {
            return true;
        }
        if (this.supportsJBoss7Markers() && Platform.getOS().equals("win32") && this.getServer().getServerState() == 2 && this.getFilesystemController() instanceof LocalFilesystemController && DeploymentMarkerUtils.markerExists(remote, this.getFilesystemController(), ".deployed")) {
            DeploymentMarkerUtils.removeDeployedMarker(remote, this.getFilesystemController());
            long timeout = System.currentTimeMillis() + (long)maxWait;
            boolean done = false;
            while (!done && System.currentTimeMillis() < timeout) {
                done = DeploymentMarkerUtils.markerExists(remote, this.getFilesystemController(), ".undeployed");
                if (done) continue;
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            return done;
        }
        return true;
    }

    @Override
    public void publishStart(IProgressMonitor monitor) throws CoreException {
        super.publishStart(monitor);
        new ServerHomeValidationUtility().validateServerHome(this.getServer(), true);
    }
}

