/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.jmx.jolokia.test.internal.connection;

import java.util.HashMap;
import javax.management.MBeanAttributeInfo;
import org.assertj.core.api.Assertions;
import org.jboss.tools.jmx.jolokia.internal.connection.JolokiaMBeanUtility;
import org.json.simple.JSONObject;
import org.junit.Test;

public class JolokiaMBeanUtilityTest {
    @Test
    public void testGetAttributeInfoWithEmptyValue() throws Exception {
        Object[] attributeInfos = new JolokiaMBeanUtility().getAttributeInfos(new JSONObject());
        Assertions.assertThat((Object[])attributeInfos).isEmpty();
    }

    @Test
    public void testGetAttributeInfoForASingleValue() throws Exception {
        JSONObject obj = new JSONObject();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", "aType");
        map.put("desc", "aDescription");
        map.put("rw", true);
        JSONObject firstJSonObject = new JSONObject(map);
        obj.put((Object)"firstObject", (Object)firstJSonObject);
        Object[] attributeInfos = new JolokiaMBeanUtility().getAttributeInfos(obj);
        Assertions.assertThat((Object[])attributeInfos).containsExactly((Object[])new MBeanAttributeInfo[]{new MBeanAttributeInfo("firstObject", "aType", "aDescription", true, true, false)});
    }

    @Test
    public void testGetAttributeInfoForSeveralValues() throws Exception {
        JSONObject obj = new JSONObject();
        String objectKey = "firstObject";
        String typeValue = "aType";
        String descValue = "aDescription";
        boolean readWriteValue = true;
        JSONObject firstJSonObject = this.createJSOnObject(typeValue, descValue, readWriteValue);
        obj.put((Object)objectKey, (Object)firstJSonObject);
        String objectKey2 = "asecondObjectInFirstPosition";
        String typeValue2 = "aSecondType";
        String descValue2 = "aSecondDescription";
        boolean readWriteValue2 = false;
        JSONObject secondJSonObject = this.createJSOnObject(typeValue2, descValue2, readWriteValue2);
        obj.put((Object)objectKey2, (Object)secondJSonObject);
        Object[] attributeInfos = new JolokiaMBeanUtility().getAttributeInfos(obj);
        Assertions.assertThat((Object[])attributeInfos).containsExactly((Object[])new MBeanAttributeInfo[]{new MBeanAttributeInfo(objectKey2, typeValue2, descValue2, readWriteValue2, readWriteValue2, false), new MBeanAttributeInfo(objectKey, typeValue, descValue, readWriteValue, readWriteValue, false)});
    }

    private JSONObject createJSOnObject(String typeValue, String descValue, boolean readWriteValue) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("type", typeValue);
        map.put("desc", descValue);
        map.put("rw", readWriteValue);
        JSONObject firstJSonObject = new JSONObject(map);
        return firstJSonObject;
    }
}

