/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.ui.test.bot;

import org.jboss.ide.eclipse.archives.ui.test.bot.ArchivesTestBase;
import org.jboss.reddeer.common.condition.WaitCondition;
import org.jboss.reddeer.common.wait.WaitWhile;
import org.jboss.reddeer.core.condition.ShellWithTextIsAvailable;
import org.jboss.reddeer.eclipse.jdt.ui.ProjectExplorer;
import org.jboss.reddeer.jface.preference.PreferencePage;
import org.jboss.reddeer.swt.impl.button.PushButton;
import org.jboss.reddeer.swt.impl.clabel.DefaultCLabel;
import org.jboss.reddeer.swt.impl.link.DefaultLink;
import org.jboss.reddeer.swt.impl.menu.ContextMenu;
import org.jboss.reddeer.swt.impl.shell.DefaultShell;
import org.jboss.reddeer.swt.impl.tree.DefaultTreeItem;
import org.jboss.reddeer.workbench.ui.dialogs.WorkbenchPreferenceDialog;
import org.jboss.tools.archives.reddeer.archives.ui.MainPreferencePage;
import org.junit.Assert;
import org.junit.Test;

public class ArchivePreferencesTest
extends ArchivesTestBase {
    private static String projectName = "ArchivePreferencesTest";

    @Test
    public void testArchivePreferences() {
        this.testGlobalArchivePreferences();
        this.testLocalArchivePreferences();
    }

    private void testGlobalArchivePreferences() {
        WorkbenchPreferenceDialog preferenceDialog = new WorkbenchPreferenceDialog();
        MainPreferencePage archivesPreferencePage = new MainPreferencePage();
        preferenceDialog.open();
        preferenceDialog.select((PreferencePage)archivesPreferencePage);
        this.checkAllSettingsInArchivePreferencePage(archivesPreferencePage);
        preferenceDialog.ok();
    }

    private void testLocalArchivePreferences() {
        ArchivePreferencesTest.createJavaProject(projectName);
        ArchivePreferencesTest.addArchivesSupport(projectName);
        ProjectExplorer pExplorer = new ProjectExplorer();
        pExplorer.open();
        pExplorer.getProject(projectName).select();
        new ContextMenu(new String[]{"Properties"}).select();
        String projectProperties = "Properties for " + projectName;
        new DefaultShell(projectProperties);
        new DefaultTreeItem(new String[]{"Project Archives"}).select();
        new DefaultLink("Configure Workspace Settings...").click();
        new DefaultShell("Preferences (Filtered)");
        try {
            new DefaultCLabel("Project Archives");
            new PushButton("Cancel").click();
            new WaitWhile((WaitCondition)new ShellWithTextIsAvailable("Preferences (Filtered)"));
            new DefaultShell("Properties for " + projectName);
            new PushButton("Cancel").click();
            new WaitWhile((WaitCondition)new ShellWithTextIsAvailable("Properties for " + projectName));
        }
        catch (Exception wnfe) {
            Assert.fail((String)"Archive global preferences page was not invoked");
        }
    }

    private void checkAllSettingsInArchivePreferencePage(MainPreferencePage archivesPreferencePage) {
        archivesPreferencePage.enableDefaultExcludes(archivesPreferencePage.isIncrementalBuilderEnabled());
        archivesPreferencePage.showBuildErrorDialog(archivesPreferencePage.isBuildErrorDialogShown());
        archivesPreferencePage.showOutputPathNextToPackages(archivesPreferencePage.isOutputPathNextToPackagesShown());
        archivesPreferencePage.showRootDirectoryOfFilesets(archivesPreferencePage.isRootDirectoryOfFilesetsShown());
        archivesPreferencePage.showProjectAtTheRoot(archivesPreferencePage.isProjectAtTheRootShown());
        archivesPreferencePage.showAllProjectsThatContainPackages(archivesPreferencePage.areAllProjectsThatContainPackagesShown());
        archivesPreferencePage.showNodeInAllProjects(archivesPreferencePage.isNodeInAllProjectShown());
        archivesPreferencePage.enableDefaultExcludes(archivesPreferencePage.isDefaultExcludesEnabled());
    }
}

