/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.ui.test.bot;

import org.jboss.ide.eclipse.archives.ui.test.bot.ArchivesTestBase;
import org.jboss.reddeer.common.exception.RedDeerException;
import org.jboss.reddeer.eclipse.ui.console.ConsoleView;
import org.jboss.reddeer.eclipse.ui.views.log.LogView;
import org.jboss.reddeer.eclipse.wst.server.ui.view.ServersView;
import org.jboss.reddeer.workbench.api.View;
import org.jboss.tools.archives.reddeer.archives.ui.ProjectArchivesView;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;

public class ArchiveViewReSwitchingTest
extends ArchivesTestBase {
    private static String projectName = "ArchiveViewReSwitchingTest";
    private static LogView errorsView = new LogView();
    private static ConsoleView consoleView = new ConsoleView();
    private static ServersView serversView = new ServersView();

    @BeforeClass
    public static void setup() {
        consoleView.open();
        serversView.open();
        errorsView.open();
        ArchiveViewReSwitchingTest.createJavaProject(projectName);
    }

    @Test
    public void testReSwitchingView() {
        view = ArchiveViewReSwitchingTest.viewForProject(projectName);
        this.assertProjectInArchivesView(view, projectName);
        this.reSwitchAndTestArchivesViewWithViews(new View[]{consoleView, serversView, errorsView});
    }

    private void reSwitchAndTestArchivesViewWithViews(View ... views) {
        View[] viewArray = views;
        int n = views.length;
        int n2 = 0;
        while (n2 < n) {
            View view = viewArray[n2];
            view.open();
            this.assertProjectInArchivesView(this.openProjectArchivesView(), projectName);
            ++n2;
        }
    }

    private void assertProjectInArchivesView(ProjectArchivesView view, String projectName) {
        try {
            view.activate();
            view.getProject(projectName);
        }
        catch (RedDeerException sle) {
            Assert.fail((String)(String.valueOf(projectName) + " is not shown in Project Archives view"));
        }
    }
}

