/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.archives.ui.test.bot;

import org.jboss.ide.eclipse.archives.ui.test.bot.ArchivesTestBase;
import org.jboss.reddeer.common.condition.WaitCondition;
import org.jboss.reddeer.common.wait.WaitUntil;
import org.jboss.reddeer.common.wait.WaitWhile;
import org.jboss.reddeer.swt.api.Tree;
import org.jboss.reddeer.swt.condition.TreeContainsItem;
import org.jboss.reddeer.swt.impl.tree.DefaultTree;
import org.jboss.tools.archives.reddeer.archives.ui.ProjectArchivesExplorer;
import org.jboss.tools.archives.reddeer.component.Archive;
import org.junit.BeforeClass;
import org.junit.Test;

public class FolderTest
extends ArchivesTestBase {
    private static final String PROJECT_1 = "FolderTest";
    private static final String PROJECT_2 = "FolderTest1";
    private static final String PROJECT_3 = "FolderTest2";
    private static final String PROJECT_1_ARCHIVE = "FolderTest.jar";
    private static final String PROJECT_1_ARCHIVE_PATH = "FolderTest.jar [/FolderTest]";
    private static final String PROJECT_2_ARCHIVE = "FolderTest1.jar";
    private static final String PROJECT_2_ARCHIVE_PATH = "FolderTest1.jar [/FolderTest1]";
    private static final String PROJECT_3_ARCHIVE = "FolderTest.jar";
    private static final String PROJECT_3_ARCHIVE_PATH = "FolderTest.jar [/FolderTest2]";
    private static final String FOLDER_1 = "a";
    private static final String FOLDER_1_NEW = "new-a";
    private static final String FOLDER_2 = "b";
    private static final String FOLDER_2_NEW = "new-b";

    @BeforeClass
    public static void setup() {
        FolderTest.createJavaProject(PROJECT_1);
        FolderTest.addArchivesSupport(PROJECT_1);
        FolderTest.createArchive(PROJECT_1, "FolderTest.jar", true);
        FolderTest.createJavaProject(PROJECT_2);
        FolderTest.addArchivesSupport(PROJECT_2);
        FolderTest.createArchive(PROJECT_2, PROJECT_2_ARCHIVE, true);
        FolderTest.createJavaProject(PROJECT_3);
        FolderTest.addArchivesSupport(PROJECT_3);
        FolderTest.createArchive(PROJECT_3, "FolderTest.jar", true);
    }

    @Test
    public void testCreatingFolder() {
        view = FolderTest.viewForProject(PROJECT_1);
        Archive archiveInView = view.getProject(PROJECT_1).getArchive(PROJECT_1_ARCHIVE_PATH);
        archiveInView.newFolder().setNameOfFolder(FOLDER_1).ok();
        new WaitUntil((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{PROJECT_1, PROJECT_1_ARCHIVE_PATH, FOLDER_1}));
        ProjectArchivesExplorer explorer = this.explorerForProject(PROJECT_1);
        Archive archiveInExplorer = explorer.getArchive(PROJECT_1_ARCHIVE_PATH);
        archiveInExplorer.newFolder().setNameOfFolder(FOLDER_2).ok();
        new WaitUntil((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{PROJECT_1, "Project Archives", PROJECT_1_ARCHIVE_PATH, FOLDER_2}));
    }

    @Test
    public void testModifyingFolder() {
        view = FolderTest.viewForProject(PROJECT_2);
        Archive archiveInView = view.getProject(PROJECT_2).getArchive(PROJECT_2_ARCHIVE_PATH);
        this.createFolder(archiveInView, PROJECT_2, PROJECT_2_ARCHIVE_PATH, FOLDER_1);
        this.createFolder(archiveInView, PROJECT_2, PROJECT_2_ARCHIVE_PATH, FOLDER_2);
        archiveInView.getFolder(FOLDER_1, false).editFolder().setNameOfFolder(FOLDER_1_NEW).ok();
        new WaitUntil((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{PROJECT_2, PROJECT_2_ARCHIVE_PATH, FOLDER_1_NEW}));
        ProjectArchivesExplorer explorer = this.explorerForProject(PROJECT_2);
        Archive archiveInExplorer = explorer.getArchive(PROJECT_2_ARCHIVE_PATH);
        archiveInExplorer.getFolder(FOLDER_2, true).editFolder().setNameOfFolder(FOLDER_2_NEW).ok();
        new WaitUntil((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{PROJECT_2, "Project Archives", PROJECT_2_ARCHIVE_PATH, FOLDER_2_NEW}));
    }

    @Test
    public void testDeletingFolder() {
        view = FolderTest.viewForProject(PROJECT_3);
        Archive archiveInView = view.getProject(PROJECT_3).getArchive(PROJECT_3_ARCHIVE_PATH);
        this.createFolder(archiveInView, PROJECT_3, PROJECT_3_ARCHIVE_PATH, FOLDER_1);
        this.createFolder(archiveInView, PROJECT_3, PROJECT_3_ARCHIVE_PATH, FOLDER_2);
        archiveInView.getFolder(FOLDER_1, false).deleteFolder(true);
        new WaitWhile((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{PROJECT_3, PROJECT_3_ARCHIVE_PATH, FOLDER_1}));
        ProjectArchivesExplorer explorer = this.explorerForProject(PROJECT_3);
        Archive archiveInExplorer = explorer.getArchive(PROJECT_3_ARCHIVE_PATH);
        archiveInExplorer.getFolder(FOLDER_2, true).deleteFolder(true);
        new WaitWhile((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{PROJECT_3, PROJECT_3_ARCHIVE_PATH, FOLDER_2}));
    }

    private void createFolder(Archive archiveInView, String project, String archivePath, String folder) {
        archiveInView.newFolder().setNameOfFolder(folder).ok();
        new WaitUntil((WaitCondition)new TreeContainsItem((Tree)new DefaultTree(), new String[]{project, archivePath, folder}));
    }
}

