/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.archives.reddeer.archives.ui;

import org.jboss.reddeer.common.condition.WaitCondition;
import org.jboss.reddeer.common.wait.WaitWhile;
import org.jboss.reddeer.core.condition.JobIsRunning;
import org.jboss.reddeer.eclipse.jdt.ui.ProjectExplorer;
import org.jboss.reddeer.swt.api.TreeItem;
import org.jboss.reddeer.swt.impl.menu.ContextMenu;
import org.jboss.reddeer.swt.impl.tree.DefaultTreeItem;
import org.jboss.tools.archives.reddeer.archives.ui.NewJarDialog;
import org.jboss.tools.archives.reddeer.component.Archive;

public class ProjectArchivesExplorer {
    private ProjectExplorer projectExplorer = new ProjectExplorer();
    private TreeItem explorer = null;
    private TreeItem projectItem = null;
    private static final String PROJECT_ARCHIVES_NODE = "Project Archives";

    public ProjectArchivesExplorer(String project) {
        this.openExplorer(project);
        this.explorer.expand();
    }

    private void openExplorer(String project) {
        this.projectExplorer.open();
        this.projectExplorer.getProject(project).select();
        this.projectItem = new DefaultTreeItem(new String[]{project});
        this.explorer = this.projectItem.getItem(PROJECT_ARCHIVES_NODE);
    }

    public NewJarDialog newJarArchive() {
        this.explorer.select();
        new ContextMenu(new String[]{"New Archive", "JAR"}).select();
        return new NewJarDialog();
    }

    public void buildProjectFull() {
        this.explorer.select();
        new ContextMenu(new String[]{"Build Project (Full)"}).select();
        new WaitWhile((WaitCondition)new JobIsRunning());
    }

    public Archive getArchive(String archiveName) {
        return new Archive(this.projectItem, this.explorer.getItem(archiveName));
    }
}

