/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.archives.reddeer.component;

import org.jboss.reddeer.common.condition.WaitCondition;
import org.jboss.reddeer.common.exception.RedDeerException;
import org.jboss.reddeer.common.logging.Logger;
import org.jboss.reddeer.common.wait.WaitWhile;
import org.jboss.reddeer.core.condition.JobIsRunning;
import org.jboss.reddeer.swt.api.TreeItem;
import org.jboss.reddeer.swt.impl.menu.ContextMenu;
import org.jboss.tools.archives.reddeer.archives.ui.NewJarDialog;
import org.jboss.tools.archives.reddeer.component.Archive;

public class ArchiveProject {
    private TreeItem archiveProject;
    protected static final Logger log = Logger.getLogger(ArchiveProject.class);

    public ArchiveProject(TreeItem archiveProject) {
        this.archiveProject = archiveProject;
    }

    public String getName() {
        return this.archiveProject.getText();
    }

    public NewJarDialog newJarArchive() {
        this.selectArchive();
        new ContextMenu(new String[]{"New Archive", "JAR"}).select();
        return new NewJarDialog();
    }

    public void buildProjectFull() {
        this.selectArchive();
        new ContextMenu(new String[]{"Build Project (Full)"}).select();
        new WaitWhile((WaitCondition)new JobIsRunning());
    }

    public Archive getArchive(String archiveName) {
        return new Archive(this.archiveProject, this.archiveProject.getItem(archiveName));
    }

    public boolean hasArchive(String archiveName) {
        try {
            this.archiveProject.getItem(archiveName);
        }
        catch (RedDeerException redDeerException) {
            return false;
        }
        return true;
    }

    public void selectArchive() {
        this.archiveProject.select();
    }
}

