/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.internal.utils;

import java.io.File;
import java.util.Arrays;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jst.j2ee.application.internal.operations.AddReferenceToEnterpriseApplicationDataModelProvider;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.operation.AddReferenceDataModelProvider;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.DataModelFactory;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.jboss.ide.eclipse.archives.webtools.filesets.vcf.WorkspaceFilesetVirtualComponent;

public class ComponentReferenceUtils {
    public static void addPathArchiveComponent(IVirtualComponent component, IPath variablePath, String folder, String name, boolean isEar) throws CoreException {
        AddReferenceToEnterpriseApplicationDataModelProvider p = isEar ? new AddReferenceToEnterpriseApplicationDataModelProvider() : new AddReferenceDataModelProvider();
        IVirtualReference ref = ComponentReferenceUtils.createPathArchiveReference(component, variablePath, folder, name);
        ComponentReferenceUtils.addReferenceToComponent(component, ref, (IDataModelProvider)p);
    }

    public static IVirtualReference createPathArchiveReference(IVirtualComponent component, IPath variablePath, String folder, String name) throws CoreException {
        IPath resolvedPath = JavaCore.getResolvedVariablePath((IPath)variablePath);
        File file = new File(resolvedPath.toOSString());
        if (file.isFile() && file.exists()) {
            String type = "var/";
            IVirtualComponent archive = ComponentCore.createArchiveComponent((IProject)component.getProject(), (String)(String.valueOf(type) + variablePath.toString()));
            VirtualReference ref = new VirtualReference(component, archive);
            ref.setArchiveName(name);
            ref.setRuntimePath((IPath)new Path(folder));
            return ref;
        }
        return null;
    }

    public static void addReferenceToComponent(IVirtualComponent component, IVirtualReference ref, IDataModelProvider provider) throws CoreException {
        if (ref == null) {
            return;
        }
        IDataModel dm = DataModelFactory.createDataModel((IDataModelProvider)provider);
        dm.setProperty("IAddReferenceDataModelProperties.SOURCE_COMPONENT", (Object)component);
        dm.setProperty("IAddReferenceDataModelProperties.TARGET_REFERENCE_LIST", Arrays.asList(ref));
        IStatus stat = dm.validate();
        if (!stat.isOK()) {
            throw new CoreException(stat);
        }
        try {
            dm.getDefaultOperation().execute((IProgressMonitor)new NullProgressMonitor(), null);
        }
        catch (ExecutionException e) {
            throw new CoreException((IStatus)new Status(4, "test", e.getMessage()));
        }
    }

    public static VirtualReference createExternalJarReference(IVirtualComponent rootComponent, IPath path, String runtimeLoc, String name) {
        return ComponentReferenceUtils.createJarReference(rootComponent, path, runtimeLoc, name, false);
    }

    public static VirtualReference createWorkspaceJarReference(IVirtualComponent rootComponent, IPath path, String runtimeLoc, String name) {
        return ComponentReferenceUtils.createJarReference(rootComponent, path, runtimeLoc, name, false);
    }

    public static VirtualReference createJarReference(IVirtualComponent rootComponent, IPath path, String runtimeLoc, String name, boolean makeRelative) {
        String type = "lib/";
        String path2 = (makeRelative ? path.makeRelative() : path).toString();
        IVirtualComponent archive = ComponentCore.createArchiveComponent((IProject)rootComponent.getProject(), (String)(String.valueOf(type) + path2));
        VirtualReference ref = new VirtualReference(rootComponent, archive);
        ref.setArchiveName(name);
        if (runtimeLoc != null) {
            ref.setRuntimePath(new Path(runtimeLoc).makeAbsolute());
        }
        return ref;
    }

    public static VirtualReference createFilesetComponentReference(IVirtualComponent root, String workspaceRelativeFolder, String includes, String excludes, String runtimePath) {
        WorkspaceFilesetVirtualComponent vc = new WorkspaceFilesetVirtualComponent(root.getProject(), root, new Path(workspaceRelativeFolder).makeAbsolute().toString());
        vc.setIncludes(includes);
        vc.setExcludes(excludes);
        VirtualReference ref = new VirtualReference(root, (IVirtualComponent)vc);
        ref.setDependencyType(1);
        ref.setRuntimePath((IPath)new Path(runtimePath));
        return ref;
    }
}

