/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.internal.utils;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.eclipse.wst.server.core.model.IModuleFolder;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.jboss.tools.test.util.JobUtils;

public class IOUtil {
    public static byte[] getBytesFromInputStream(InputStream is) {
        if (is == null) {
            return null;
        }
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        try {
            int nRead;
            byte[] data = new byte[16384];
            while ((nRead = is.read(data, 0, data.length)) != -1) {
                buffer.write(data, 0, nRead);
            }
            buffer.flush();
            return buffer.toByteArray();
        }
        catch (IOException ioe) {
            return null;
        }
    }

    public static void setContents(IFile file, String val) throws IOException, CoreException {
        if (!file.exists()) {
            file.create((InputStream)new ByteArrayInputStream(val.getBytes()), false, null);
        } else {
            file.setContents((InputStream)new ByteArrayInputStream(val.getBytes()), false, false, (IProgressMonitor)new NullProgressMonitor());
        }
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        JobUtils.waitForIdle();
    }

    public static void setContents(File file, String contents) throws IOException {
        byte[] buffer = new byte[65536];
        ByteArrayInputStream in = new ByteArrayInputStream(contents.getBytes());
        try (OutputStream out = null;){
            out = new BufferedOutputStream(new FileOutputStream(file));
            int avail = in.read(buffer);
            while (avail > 0) {
                out.write(buffer, 0, avail);
                avail = in.read(buffer);
            }
        }
    }

    public static String getContents(File aFile) throws IOException {
        return new String(IOUtil.getBytesFromFile(aFile));
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        FileInputStream is = new FileInputStream(file);
        byte[] bytes = new byte[(int)file.length()];
        int offset = 0;
        int numRead = 0;
        while (offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0) {
            offset += numRead;
        }
        ((InputStream)is).close();
        return bytes;
    }

    public static int countFiles(File root) {
        int count = 0;
        if (!root.isDirectory()) {
            return 1;
        }
        File[] children = root.listFiles();
        int i = 0;
        while (i < children.length) {
            count += IOUtil.countFiles(children[i]);
            ++i;
        }
        return count;
    }

    public static int countAllResources(IModuleResource[] members) {
        int total = 0;
        int i = 0;
        while (i < members.length) {
            ++total;
            if (members[i] instanceof IModuleFolder) {
                total += IOUtil.countAllResources(((IModuleFolder)members[i]).members());
            }
            ++i;
        }
        return total;
    }

    public static int countAllResources(File root) {
        int count = 0;
        if (!root.isDirectory()) {
            return 1;
        }
        File[] children = root.listFiles();
        int i = 0;
        while (i < children.length) {
            count += IOUtil.countAllResources(children[i]);
            ++i;
        }
        return 1 + count;
    }

    public static void unzipFile(IPath zipped, IPath toLoc) {
        toLoc.toFile().mkdirs();
        int BUFFER = 2048;
        try {
            ZipEntry entry;
            BufferedOutputStream dest = null;
            FileInputStream fis = new FileInputStream(zipped.toFile());
            ZipInputStream zis = new ZipInputStream(new BufferedInputStream(fis));
            while ((entry = zis.getNextEntry()) != null) {
                int count;
                byte[] data = new byte[2048];
                if (entry.isDirectory()) {
                    toLoc.append(entry.getName()).toFile().mkdirs();
                    continue;
                }
                toLoc.append(entry.getName()).toFile().getParentFile().mkdirs();
                if (toLoc.append(entry.getName()).toFile().exists()) continue;
                String out = toLoc.append(entry.getName()).toOSString();
                FileOutputStream fos = new FileOutputStream(out);
                dest = new BufferedOutputStream(fos, 2048);
                while ((count = zis.read(data, 0, 2048)) != -1) {
                    dest.write(data, 0, count);
                }
                dest.flush();
                dest.close();
            }
            zis.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isZip(File file) {
        if (file.isDirectory()) {
            return false;
        }
        if (!file.canRead()) {
            return false;
        }
        if (file.length() < 4L) {
            return false;
        }
        try {
            DataInputStream in = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
            int test = in.readInt();
            in.close();
            return test == 1347093252;
        }
        catch (IOException ioe) {
            return false;
        }
    }

    public static IModuleFile findFile(IModuleFile[] files, String needle) {
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                if (files[i].getName().equals(needle)) {
                    return files[i];
                }
                ++i;
            }
        }
        return null;
    }

    public static void copyFolder(File src, File dest) throws IOException {
        if (src.isDirectory()) {
            String[] files;
            if (!dest.exists()) {
                dest.mkdirs();
            }
            String[] stringArray = files = src.list();
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                File srcFile = new File(src, file);
                File destFile = new File(dest, file);
                IOUtil.copyFolder(srcFile, destFile);
                ++n2;
            }
        } else {
            int length;
            FileInputStream in = new FileInputStream(src);
            FileOutputStream out = new FileOutputStream(dest);
            byte[] buffer = new byte[1024];
            while ((length = ((InputStream)in).read(buffer)) > 0) {
                ((OutputStream)out).write(buffer, 0, length);
            }
            ((InputStream)in).close();
            ((OutputStream)out).close();
        }
    }
}

