/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.internal.utils;

import java.util.HashMap;
import java.util.Set;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jst.server.core.IEnterpriseApplication;
import org.eclipse.jst.server.core.IJ2EEModule;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IModule2;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.jboss.tools.as.test.core.internal.utils.MockModuleType;

public class MockModule
extends ModuleDelegate
implements IModule,
IModule2,
IEnterpriseApplication,
IJ2EEModule {
    private String id;
    private String name;
    private MockModuleType type;
    private HashMap<IModule, String> children;
    private IModuleResource[] members;
    private IProject project;
    private boolean exists = false;
    private boolean binary = false;
    private boolean external = false;
    private HashMap<String, String> props;

    public MockModule(String id, String name, String typeId, String typeName, String typeVersion) {
        this.id = id;
        this.name = name;
        this.type = new MockModuleType(typeId, typeName, typeVersion);
        this.children = new HashMap();
        this.project = null;
        this.props = new HashMap();
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public IModuleType getModuleType() {
        return this.type;
    }

    public IProject getProject() {
        return this.project;
    }

    public boolean isExternal() {
        return this.external;
    }

    public boolean exists() {
        return this.exists;
    }

    public void setExists(boolean b) {
        this.exists = b;
    }

    public void setBinary(boolean b) {
        this.binary = b;
    }

    public void setExternal(boolean b) {
        this.external = b;
    }

    public boolean isBinary() {
        return this.binary;
    }

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IEnterpriseApplication.class)) {
            return this;
        }
        if (adapter.equals(IJ2EEModule.class)) {
            return this;
        }
        if (adapter.equals(ModuleDelegate.class)) {
            return this;
        }
        return null;
    }

    public Object loadAdapter(Class adapter, IProgressMonitor monitor) {
        return this.getAdapter(adapter);
    }

    public void addChildModule(IModule child, String relativeURI) {
        this.children.put(child, relativeURI);
    }

    public void clearChildren() {
        this.children.clear();
    }

    public IModule[] getModules() {
        Set<IModule> s = this.children.keySet();
        return s.toArray(new IModule[s.size()]);
    }

    public String getURI(IModule module) {
        return this.children.get(module);
    }

    public IContainer[] getResourceFolders() {
        return null;
    }

    public IStatus validate() {
        return Status.OK_STATUS;
    }

    public IModule[] getChildModules() {
        return this.getModules();
    }

    public IModuleResource[] members() throws CoreException {
        return this.members;
    }

    public void setMembers(IModuleResource[] members) {
        this.members = members;
    }

    public void setProject(IProject p) {
        this.project = p;
    }

    public IContainer[] getJavaOutputFolders() {
        return new IContainer[0];
    }

    public int hashCode() {
        return (String.valueOf(this.getModuleType().getId()) + ":" + this.getId() + ":" + this.getName()).hashCode();
    }

    public boolean equals(Object other) {
        if (!(other instanceof MockModule)) {
            return false;
        }
        MockModule o2 = (MockModule)((Object)other);
        return o2.getModuleType().getId().equals(this.getModuleType().getId()) && o2.getId().equals(this.getId()) && o2.getName().equals(this.getName());
    }

    public void setProperty(String k, String v) {
        this.props.put(k, v);
    }

    public String getProperty(String key) {
        return this.props.get(key);
    }
}

