/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.parametized.server.publishing.defect;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.jboss.ide.eclipse.as.core.publishers.PublishUtil;
import org.jboss.tools.as.test.core.ASMatrixTests;
import org.jboss.tools.as.test.core.internal.utils.IOUtil;
import org.jboss.tools.as.test.core.internal.utils.MatrixUtils;
import org.jboss.tools.as.test.core.internal.utils.MockModule;
import org.jboss.tools.as.test.core.internal.utils.MockModuleUtil;
import org.jboss.tools.as.test.core.parametized.server.publishing.AbstractPublishingTest;
import org.jboss.tools.as.test.core.subsystems.impl.CustomPublishController;
import org.jboss.tools.runtime.core.extract.ExtractUtility;
import org.jboss.tools.runtime.core.extract.IOverwrite;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class PerModuleZipTest
extends AbstractPublishingTest {
    private IModule[] module;
    private String zipModule;

    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        String[] zipDefault = new String[]{"unzipped", "zipped"};
        String[] zipModule = new String[]{"unzipped", "zipped", "zipUnset"};
        Object[][] allOptions = new Object[][]{zipDefault, zipModule};
        return MatrixUtils.toMatrix(allOptions);
    }

    public PerModuleZipTest(String zip, String zipModule) {
        super("org.jboss.ide.eclipse.as.71", zip, "metadata", "permod_default");
        this.zipModule = zipModule;
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp(false);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected void createProjects() throws Exception {
        this.module = this.createUtilInWebModule("TestWeb", "TestUtil");
        this.addModuleToServer(this.module[0]);
        Boolean zipMod = null;
        if ("zipped".equals(this.zipModule)) {
            zipMod = new Boolean(true);
        } else if ("unzipped".equals(this.zipModule)) {
            zipMod = new Boolean(false);
        }
        this.setCustomZipForModule(this.wc, this.module[this.module.length - 1], zipMod);
    }

    @Test
    public void testPublish() throws Exception {
        boolean zipUtil;
        CustomPublishController controller = new CustomPublishController();
        controller.initialize((IServerAttributes)this.server, null, null);
        IModule[] web = new IModule[]{this.module[0]};
        IModule[] utilInWeb = new IModule[]{this.module[0], this.module[1]};
        this.setUnderlyingVersion(1);
        this.setUtilUnderlyingVersion(1);
        controller.publishStart((IProgressMonitor)new NullProgressMonitor());
        controller.publishServer(1, (IProgressMonitor)new NullProgressMonitor());
        int resultWeb = controller.publishModule(2, 1, web, (IProgressMonitor)new NullProgressMonitor());
        int resultUtil = controller.publishModule(2, 1, utilInWeb, (IProgressMonitor)new NullProgressMonitor());
        controller.publishFinish((IProgressMonitor)new NullProgressMonitor());
        PerModuleZipTest.assertEquals((int)resultWeb, (int)1);
        PerModuleZipTest.assertEquals((int)resultUtil, (int)1);
        IPath webPath = controller.getDeployPathController().getDeployDirectory(web);
        PerModuleZipTest.assertTrue((boolean)webPath.toString().contains("TestWeb"));
        PerModuleZipTest.assertTrue((boolean)webPath.toFile().exists());
        IPath utilJar = webPath.append("WEB-INF/lib/util.jar");
        boolean zipWar = this.param_zip.equals("zipped");
        boolean bl = zipUtil = zipWar || "zipped".equals(this.zipModule) || "zipUnset".equals(this.zipModule) && PublishUtil.deployPackaged((IModule[])this.module, (IServer)this.server);
        if (zipWar) {
            PerModuleZipTest.assertTrue((boolean)webPath.toFile().isFile());
            PerModuleZipTest.assertTrue((boolean)webPath.toFile().exists());
            PerModuleZipTest.assertFalse((boolean)utilJar.toFile().exists());
            ExtractUtility ex = new ExtractUtility(webPath.toFile(), 1);
            ex.extract(webPath.toFile().getParentFile(), new IOverwrite(){

                public int overwrite(File file) {
                    return 0;
                }
            }, (IProgressMonitor)new NullProgressMonitor());
            IPath utilJar2 = webPath.removeLastSegments(1).append("WEB-INF/lib/util.jar");
            PerModuleZipTest.assertTrue((boolean)utilJar2.toFile().exists());
            PerModuleZipTest.assertTrue((boolean)utilJar2.toFile().isFile());
        } else {
            PerModuleZipTest.assertTrue((boolean)webPath.toFile().isDirectory());
            PerModuleZipTest.assertTrue((boolean)utilJar.toFile().exists());
            PerModuleZipTest.assertEquals((boolean)utilJar.toFile().isFile(), (boolean)zipUtil);
        }
    }

    private IPath getUnderlying() {
        IPath underlying = ASMatrixTests.getDefault().getStateLocation().append("underlying.txt");
        return underlying;
    }

    private IPath getUtilUnderlying() {
        IPath underlying = ASMatrixTests.getDefault().getStateLocation().append("\u7b28.txt");
        return underlying;
    }

    private IPath setUnderlyingVersion(int v) throws Exception {
        IPath underlying = this.getUnderlying();
        underlying.toFile().getParentFile().mkdirs();
        IOUtil.setContents(underlying.toFile(), "version" + v);
        return underlying;
    }

    private IPath setUtilUnderlyingVersion(int v) throws Exception {
        IPath underlying = this.getUtilUnderlying();
        underlying.toFile().getParentFile().mkdirs();
        IOUtil.setContents(underlying.toFile(), "version" + v);
        return underlying;
    }

    private IPath[] getUtilLeafPaths() {
        return new IPath[]{new Path("\u7b28.txt")};
    }

    private IPath[] getWebLeafPaths() {
        IPath[] leafs = new IPath[]{new Path("w.txt")};
        return leafs;
    }

    private MockModule[] createUtilInWebModule(String webName, String utilName) throws Exception {
        IPath underlying = this.setUnderlyingVersion(1);
        IPath utilUnderlying = this.setUtilUnderlyingVersion(1);
        MockModule web = MockModuleUtil.createMockWebModule();
        web.setProperty("org.eclipse.wst.server.core.deployName", webName);
        MockModule util = MockModuleUtil.createMockUtilModule();
        util.setProperty("org.eclipse.wst.server.core.deployName", utilName);
        web.addChildModule(util, "WEB-INF/lib/util.jar");
        IPath[] webLeafs = this.getWebLeafPaths();
        IModuleResource[] webR = MockModuleUtil.createMockResources(webLeafs, new IPath[0], underlying.toFile());
        web.setMembers(webR);
        web.setExists(true);
        IPath[] utilLeafs = this.getUtilLeafPaths();
        IModuleResource[] utilR = MockModuleUtil.createMockResources(utilLeafs, new IPath[0], utilUnderlying.toFile());
        util.setMembers(utilR);
        util.setExists(true);
        return new MockModule[]{web, util};
    }

    protected void verifyListRelativePath(IPath root, List<IPath> list, boolean exists) {
        ArrayList<IPath> list2 = new ArrayList<IPath>();
        Iterator<IPath> i = list.iterator();
        while (i.hasNext()) {
            list2.add(root.append(i.next()));
        }
        super.verifyList(root, list2, exists);
    }
}

