/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.parametized.server.publishing.sar;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.common.project.facet.core.runtime.IRuntime;
import org.eclipse.wst.common.project.facet.core.runtime.RuntimeManager;
import org.eclipse.wst.server.core.IModuleType;
import org.eclipse.wst.server.core.IServer;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.jboss.tools.as.test.core.internal.utils.wtp.JavaEEFacetConstants;
import org.jboss.tools.as.test.core.parametized.server.ServerParameterUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class SarModuleTest
extends TestCase {
    private String serverType;
    private IServer server;

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        ArrayList<String> list = new ArrayList<String>();
        list.addAll(Arrays.asList(ServerParameterUtils.getAllJBossServerTypeParamterers()));
        list.remove("org.jboss.ide.eclipse.as.32");
        return ServerParameterUtils.asCollection(list.toArray(new Object[list.size()]));
    }

    public SarModuleTest(String serverType) {
        this.serverType = serverType;
    }

    @Before
    public void setUp() {
        this.server = ServerCreationTestUtils.createMockServerWithRuntime(this.serverType, String.valueOf(((Object)((Object)this)).getClass().getName()) + this.serverType);
    }

    @After
    public void tearDown() throws Exception {
        ServerCreationTestUtils.deleteAllServersAndRuntimes();
    }

    @Test
    public void testServerSupportsModuleVersion1() throws CoreException {
        this._testServerSupportsModuleVersion("1.0");
    }

    protected void _testServerSupportsModuleVersion(String version) {
        IModuleType[] types = this.server.getServerType().getRuntimeType().getModuleTypes();
        int i = 0;
        while (i < types.length) {
            if (types[i].getId().equals("jst.jboss.sar") && version.equals(types[i].getVersion())) {
                return;
            }
            ++i;
        }
        SarModuleTest.fail((String)("JBoss server " + this.server.getServerType().getId() + " does not support sar " + version));
    }

    @Test
    public void testServerFacetSupport() throws CoreException {
        if (this.server.getServerType().getId().equals("org.jboss.ide.eclipse.as.systemCopyServer")) {
            return;
        }
        this._testServerFacetSupport(JavaEEFacetConstants.SAR_1);
    }

    protected void _testServerFacetSupport(IProjectFacetVersion fv) {
        Set set = RuntimeManager.getRuntimes();
        Iterator i = set.iterator();
        IRuntime next = null;
        String rtTypeId = this.server.getRuntime().getRuntimeType().getId();
        System.out.println(rtTypeId);
        if (rtTypeId.contains("eap")) {
            System.err.println("Break");
        }
        while (i.hasNext()) {
            next = (IRuntime)i.next();
            System.out.println("   " + next.getName());
            if (!next.getName().equals(rtTypeId)) continue;
            SarModuleTest.assertTrue((String)("Runtime type " + rtTypeId + " does not support facet version " + fv.toString()), (boolean)next.supports(fv));
            return;
        }
        SarModuleTest.fail((String)"Runtime for server not found.");
    }
}

