/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.subsystems;

import java.io.File;
import java.util.HashMap;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.jboss.ide.eclipse.as.core.server.IDeployableServer;
import org.jboss.ide.eclipse.as.core.util.ServerConverter;
import org.jboss.ide.eclipse.as.wtp.core.server.behavior.LocalFilesystemController;
import org.jboss.tools.as.test.core.ASMatrixTests;
import org.jboss.tools.as.test.core.internal.utils.IOUtil;
import org.jboss.tools.as.test.core.internal.utils.ServerCreationTestUtils;
import org.junit.After;
import org.junit.Test;

public class LocalFilesystemSubsystemTest
extends TestCase {
    @After
    public void tearDown() throws Exception {
        ASMatrixTests.cleanup();
    }

    @Test
    public void testFilesystemTemporaryFolder() {
        TestLocalFilesystemController controller = new TestLocalFilesystemController();
        controller.initialize(null, null, this.createEnvironmentTempFolder1());
        LocalFilesystemSubsystemTest.assertEquals((Object)controller.getTempFolder(), (Object)this.getStateLocationPath("tmpdir1").toFile());
    }

    @Test
    public void testCopyFile() throws Exception {
        IPath tmpfile = this.getStateLocationPath("tmpfile1.txt");
        IPath destination = this.getStateLocationPath("dest/copiedFile.txt");
        IOUtil.setContents(tmpfile.toFile(), "hello");
        TestLocalFilesystemController controller = new TestLocalFilesystemController();
        controller.initialize(null, null, this.createEnvironmentTempFolder1());
        controller.copyFile(tmpfile.toFile(), destination, (IProgressMonitor)new NullProgressMonitor());
        String copiedContents = IOUtil.getContents(destination.toFile());
        LocalFilesystemSubsystemTest.assertEquals((String)copiedContents, (String)"hello");
    }

    @Test
    public void testDeleteResource() throws Exception {
        IPath tmpfile = this.getStateLocationPath("tmpfile2.txt");
        IOUtil.setContents(tmpfile.toFile(), "hello");
        TestLocalFilesystemController controller = new TestLocalFilesystemController();
        controller.initialize(null, null, this.createEnvironmentTempFolder1());
        controller.deleteResource(tmpfile, (IProgressMonitor)new NullProgressMonitor());
        LocalFilesystemSubsystemTest.assertFalse((boolean)tmpfile.toFile().exists());
    }

    @Test
    public void testIsFile() throws Exception {
        IPath tmpfile = this.getStateLocationPath("tmpfile3.txt");
        TestLocalFilesystemController controller = new TestLocalFilesystemController();
        controller.initialize(null, null, this.createEnvironmentTempFolder1());
        LocalFilesystemSubsystemTest.assertFalse((boolean)controller.isFile(tmpfile, (IProgressMonitor)new NullProgressMonitor()));
        IOUtil.setContents(tmpfile.toFile(), "hello");
        LocalFilesystemSubsystemTest.assertTrue((boolean)controller.isFile(tmpfile, (IProgressMonitor)new NullProgressMonitor()));
    }

    @Test
    public void testMakeDirectoryIfRequired() throws Exception {
        TestLocalFilesystemController controller = new TestLocalFilesystemController();
        controller.initialize(null, null, this.createEnvironmentTempFolder1());
        IPath tmpfile = this.getStateLocationPath("someFolder");
        LocalFilesystemSubsystemTest.assertFalse((boolean)tmpfile.toFile().exists());
        controller.makeDirectoryIfRequired(tmpfile, (IProgressMonitor)new NullProgressMonitor());
        LocalFilesystemSubsystemTest.assertTrue((boolean)tmpfile.toFile().exists());
    }

    @Test
    public void testMakeDirectoryIfRequiredDeep() throws Exception {
        TestLocalFilesystemController controller = new TestLocalFilesystemController();
        controller.initialize(null, null, this.createEnvironmentTempFolder1());
        IPath tmpfile = this.getStateLocationPath("someFolder/inner/three");
        LocalFilesystemSubsystemTest.assertFalse((boolean)tmpfile.toFile().exists());
        controller.makeDirectoryIfRequired(tmpfile, (IProgressMonitor)new NullProgressMonitor());
        LocalFilesystemSubsystemTest.assertTrue((boolean)tmpfile.toFile().exists());
    }

    @Test
    public void testTouchResource() throws Exception {
        IPath tmpfile = this.getStateLocationPath("tmpfile5.txt");
        TestLocalFilesystemController controller = new TestLocalFilesystemController();
        controller.initialize(null, null, this.createEnvironmentTempFolder1());
        LocalFilesystemSubsystemTest.assertFalse((boolean)tmpfile.toFile().exists());
        controller.touchResource(tmpfile, (IProgressMonitor)new NullProgressMonitor());
        LocalFilesystemSubsystemTest.assertTrue((boolean)tmpfile.toFile().exists());
    }

    @Test
    public void testTemporaryDeployFolderForServer() throws Exception {
        try {
            try {
                IServer server = ServerCreationTestUtils.createMockServerWithRuntime("org.jboss.ide.eclipse.as.systemCopyServer", String.valueOf(((Object)((Object)this)).getClass().getName()) + "org.jboss.ide.eclipse.as.systemCopyServer");
                IServerWorkingCopy wc = server.createWorkingCopy();
                IDeployableServer ds = ServerConverter.getDeployableServer((IServerAttributes)wc);
                ds.setDeployLocationType("custom");
                ds.setTempDeployFolder(this.getStateLocationPath("someotherpath2").toOSString());
                server = wc.save(false, (IProgressMonitor)new NullProgressMonitor());
                TestLocalFilesystemController controller = new TestLocalFilesystemController();
                controller.initialize((IServerAttributes)server, null, null);
                File f = controller.getTempFolder();
                LocalFilesystemSubsystemTest.assertEquals((String)f.getName(), (String)"someotherpath2");
            }
            catch (CoreException ce) {
                LocalFilesystemSubsystemTest.fail();
                ASMatrixTests.cleanup();
            }
        }
        finally {
            ASMatrixTests.cleanup();
        }
    }

    private Map<String, Object> createEnvironmentTempFolder1() {
        HashMap<String, Object> env = new HashMap<String, Object>();
        IPath loc = this.getStateLocationPath("tmpdir1");
        loc.toFile().mkdirs();
        env.put("ISubsystemController.TemporaryDeployFolder", loc);
        return env;
    }

    private IPath getStateLocationPath(String path) {
        return ASMatrixTests.getDefault().getStateLocation().append(path);
    }

    public class TestLocalFilesystemController
    extends LocalFilesystemController {
        protected File getTempFolder() {
            File s = super.getTempFolder();
            return s;
        }
    }
}

