/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.test.core.subsystems;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerAttributes;
import org.eclipse.wst.server.core.model.IModuleResource;
import org.eclipse.wst.server.core.model.IModuleResourceDelta;
import org.eclipse.wst.server.core.model.ModuleDelegate;
import org.jboss.ide.eclipse.as.core.server.internal.ExtendedServerPropertiesAdapterFactory;
import org.jboss.ide.eclipse.as.core.server.internal.extendedproperties.ServerExtendedProperties;
import org.jboss.ide.eclipse.as.core.server.internal.v7.DeploymentMarkerUtils;
import org.jboss.ide.eclipse.as.core.util.ModuleResourceUtil;
import org.jboss.tools.as.test.core.ASMatrixTests;
import org.jboss.tools.as.test.core.internal.utils.IOUtil;
import org.jboss.tools.as.test.core.internal.utils.MockModule;
import org.jboss.tools.as.test.core.internal.utils.MockModuleUtil;
import org.jboss.tools.as.test.core.parametized.server.publishing.AbstractPublishingTest;
import org.jboss.tools.as.test.core.subsystems.impl.CustomPublishController;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class StandardFilesystemPublishControllerTest
extends AbstractPublishingTest {
    private IModule[] module;

    @Parameterized.Parameters
    public static Collection<Object[]> params() {
        return StandardFilesystemPublishControllerTest.defaultData();
    }

    public StandardFilesystemPublishControllerTest(String serverType, String zip, String deployLoc, String perMod) {
        super(serverType, zip, deployLoc, perMod);
    }

    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp(false);
    }

    @Override
    @After
    public void tearDown() throws Exception {
        super.tearDown();
    }

    @Override
    protected void createProjects() throws Exception {
        this.module = this.createSimpleMockWebModule();
        this.addModuleToServer(this.module[0]);
    }

    @Test
    public void testPublish() throws Exception {
        CustomPublishController controller = new CustomPublishController();
        controller.initialize((IServerAttributes)this.server, null, null);
        int result = controller.publishModule(1, 1, this.module, null);
        StandardFilesystemPublishControllerTest.assertEquals((int)result, (int)1);
        String s = controller.getDeployPathController().getDeployDirectory(this.module).toOSString();
        StandardFilesystemPublishControllerTest.assertTrue((boolean)new Path(s).toFile().exists());
        StandardFilesystemPublishControllerTest.assertEquals((boolean)this.testIsZip(), (boolean)new Path(s).toFile().isFile());
        this.verifyListRelativePath((IPath)new Path(s), Arrays.asList(this.getLeafPaths()), true);
    }

    @Test
    public void testPublishModuleDNE() throws Exception {
        ((MockModule)this.module[0]).setExists(false);
        CustomPublishController controller = new CustomPublishController();
        controller.initialize((IServerAttributes)this.server, null, null);
        int result = controller.publishModule(1, 1, this.module, null);
        StandardFilesystemPublishControllerTest.assertEquals((int)result, (int)0);
        String s = controller.getDeployPathController().getDeployDirectory(this.module).toOSString();
        StandardFilesystemPublishControllerTest.assertFalse((boolean)new Path(s).toFile().exists());
    }

    @Test
    public void testBinaryModulePublish() throws Exception {
        this.module = this.createSimpleMockBinaryWebModule();
        ((MockModule)this.module[0]).setExists(true);
        ((MockModule)this.module[0]).setBinary(true);
        CustomPublishController controller = new CustomPublishController();
        controller.initialize((IServerAttributes)this.server, null, null);
        int result = controller.publishModule(1, 1, this.module, null);
        StandardFilesystemPublishControllerTest.assertEquals((int)result, (int)1);
        String s = controller.getDeployPathController().getDeployDirectory(this.module).toOSString();
        StandardFilesystemPublishControllerTest.assertTrue((boolean)new Path(s).toFile().exists());
        StandardFilesystemPublishControllerTest.assertTrue((boolean)new Path(s).toFile().isFile());
        IModuleResource[] resources = ModuleResourceUtil.getResources((IModule)this.module[0], (IProgressMonitor)new NullProgressMonitor());
        StandardFilesystemPublishControllerTest.assertTrue((resources.length == 1 ? 1 : 0) != 0);
    }

    @Test
    public void testUtilInWebMockModule() throws Exception {
        this.module = this.createUtilInWebMockModule();
        ((MockModule)this.module[0]).setExists(true);
        ((MockModule)this.module[0]).setExternal(true);
        ((MockModule)this.module[0]).setBinary(false);
        ((MockModule)this.module[1]).setExists(true);
        ((MockModule)this.module[1]).setExternal(true);
        ((MockModule)this.module[1]).setBinary(false);
        CustomPublishController controller = new CustomPublishController();
        controller.initialize((IServerAttributes)this.server, null, null);
        int result = controller.publishModule(1, 1, new IModule[]{this.module[0]}, null);
        StandardFilesystemPublishControllerTest.assertEquals((int)result, (int)1);
        int resultUtil = controller.publishModule(1, 1, this.module, null);
        StandardFilesystemPublishControllerTest.assertEquals((int)resultUtil, (int)1);
        String webDepDir = controller.getDeployPathController().getDeployDirectory(new IModule[]{this.module[0]}).toOSString();
        StandardFilesystemPublishControllerTest.assertTrue((boolean)new Path(webDepDir).toFile().exists());
        StandardFilesystemPublishControllerTest.assertEquals((boolean)this.testIsZip(), (boolean)new Path(webDepDir).toFile().isFile());
        this.verifyListRelativePath((IPath)new Path(webDepDir), Arrays.asList(new Path("index.html")), true);
        String utilDepDir = controller.getDeployPathController().getDeployDirectory(this.module).toOSString();
        if (!this.testIsZip()) {
            ServerExtendedProperties props = ExtendedServerPropertiesAdapterFactory.getServerExtendedProperties((IServerAttributes)this.server);
            StandardFilesystemPublishControllerTest.assertNotNull((Object)props);
            boolean allowExplodedUtil = props.allowExplodedModulesInWarLibs();
            StandardFilesystemPublishControllerTest.assertTrue((boolean)new Path(utilDepDir).toFile().exists());
            StandardFilesystemPublishControllerTest.assertEquals((!allowExplodedUtil ? 1 : 0) != 0, (boolean)new Path(utilDepDir).toFile().isFile());
            this.verifyListRelativePath((IPath)new Path(utilDepDir), Arrays.asList(new Path("Main.class")), true);
        } else {
            IPath utilRelToWeb = new Path(utilDepDir).removeFirstSegments(new Path(webDepDir).segmentCount());
            this.verifyListRelativePath((IPath)new Path(webDepDir), Arrays.asList(utilRelToWeb.append("Main.class")), true);
        }
    }

    @Test
    public void testJBIDE_22878UtilInWebMockModule() throws Exception {
        this.module = this.createDifferentURIBinaryUtilInWebMockModule("simple-ejb-1.5.0.jar", "simple-ejb.jar");
        ((MockModule)this.module[0]).setExists(true);
        ((MockModule)this.module[0]).setExternal(true);
        ((MockModule)this.module[0]).setBinary(false);
        ((MockModule)this.module[1]).setExists(true);
        ((MockModule)this.module[1]).setExternal(true);
        ((MockModule)this.module[1]).setBinary(true);
        CustomPublishController controller = new CustomPublishController();
        controller.initialize((IServerAttributes)this.server, null, null);
        int result = controller.publishModule(1, 1, new IModule[]{this.module[0]}, null);
        StandardFilesystemPublishControllerTest.assertEquals((int)result, (int)1);
        int resultUtil = controller.publishModule(1, 1, this.module, null);
        StandardFilesystemPublishControllerTest.assertEquals((int)resultUtil, (int)1);
        String webDepDir = controller.getDeployPathController().getDeployDirectory(new IModule[]{this.module[0]}).toOSString();
        StandardFilesystemPublishControllerTest.assertTrue((boolean)new Path(webDepDir).toFile().exists());
        StandardFilesystemPublishControllerTest.assertEquals((boolean)this.testIsZip(), (boolean)new Path(webDepDir).toFile().isFile());
        this.verifyListRelativePath((IPath)new Path(webDepDir), Arrays.asList(new Path("index.html")), true);
        String utilDepDir = controller.getDeployPathController().getDeployDirectory(this.module).toOSString();
        if (!this.testIsZip()) {
            ServerExtendedProperties props = ExtendedServerPropertiesAdapterFactory.getServerExtendedProperties((IServerAttributes)this.server);
            StandardFilesystemPublishControllerTest.assertNotNull((Object)props);
            StandardFilesystemPublishControllerTest.assertTrue((boolean)new Path(utilDepDir).toFile().exists());
            StandardFilesystemPublishControllerTest.assertEquals((boolean)true, (boolean)new Path(utilDepDir).toFile().isFile());
        } else {
            IPath utilRelToWeb = new Path(utilDepDir).removeFirstSegments(new Path(webDepDir).segmentCount());
            this.verifyListRelativePath((IPath)new Path(webDepDir), Arrays.asList(utilRelToWeb), true);
        }
    }

    @Test
    public void testUtilInWebInEarMockModule() throws Exception {
        this.module = this.createUtilInWebInEarMockModule();
        ((MockModule)this.module[0]).setExists(true);
        ((MockModule)this.module[0]).setExternal(true);
        ((MockModule)this.module[0]).setBinary(false);
        ((MockModule)this.module[1]).setExists(true);
        ((MockModule)this.module[1]).setExternal(true);
        ((MockModule)this.module[1]).setBinary(false);
        ((MockModule)this.module[2]).setExists(true);
        ((MockModule)this.module[2]).setExternal(true);
        ((MockModule)this.module[2]).setBinary(false);
        CustomPublishController controller = new CustomPublishController();
        controller.initialize((IServerAttributes)this.server, null, null);
        int result = controller.publishModule(1, 1, new IModule[]{this.module[0]}, null);
        StandardFilesystemPublishControllerTest.assertEquals((int)result, (int)1);
        int resultWeb = controller.publishModule(1, 1, new IModule[]{this.module[0], this.module[1]}, null);
        StandardFilesystemPublishControllerTest.assertEquals((int)resultWeb, (int)1);
        int resultUtil = controller.publishModule(1, 1, this.module, null);
        StandardFilesystemPublishControllerTest.assertEquals((int)resultUtil, (int)1);
        String earDepDir = controller.getDeployPathController().getDeployDirectory(new IModule[]{this.module[0]}).toOSString();
        StandardFilesystemPublishControllerTest.assertTrue((boolean)new Path(earDepDir).toFile().exists());
        StandardFilesystemPublishControllerTest.assertEquals((boolean)this.testIsZip(), (boolean)new Path(earDepDir).toFile().isFile());
        this.verifyListRelativePath((IPath)new Path(earDepDir), Arrays.asList(new Path("META-INF/application.xml")), true);
        String webDepDir = controller.getDeployPathController().getDeployDirectory(new IModule[]{this.module[0], this.module[1]}).toOSString();
        this.utilInWebInEarRemovals_verifyWeb(webDepDir, earDepDir, true);
        String utilDepDir = controller.getDeployPathController().getDeployDirectory(this.module).toOSString();
        this.utilInWebInEarRemovals_verifyUtil(utilDepDir, earDepDir, true);
    }

    @Test
    public void testUtilInWebInEarRestartModule() throws Exception {
        this.module = this.createUtilInWebInEarMockModule();
        ((MockModule)this.module[0]).setExists(true);
        ((MockModule)this.module[0]).setBinary(false);
        ((MockModule)this.module[1]).setExists(true);
        ((MockModule)this.module[1]).setBinary(false);
        ((MockModule)this.module[2]).setExists(true);
        ((MockModule)this.module[2]).setBinary(false);
        CustomPublishController controller = new CustomPublishController();
        controller.initialize((IServerAttributes)this.server, null, null);
        int result = controller.publishModule(1, 1, new IModule[]{this.module[0]}, null);
        StandardFilesystemPublishControllerTest.assertEquals((int)result, (int)1);
        int resultWeb = controller.publishModule(1, 1, new IModule[]{this.module[0], this.module[1]}, null);
        StandardFilesystemPublishControllerTest.assertEquals((int)resultWeb, (int)1);
        int resultUtil = controller.publishModule(1, 1, this.module, null);
        StandardFilesystemPublishControllerTest.assertEquals((int)resultUtil, (int)1);
        String earDepDir = controller.getDeployPathController().getDeployDirectory(new IModule[]{this.module[0]}).toOSString();
        StandardFilesystemPublishControllerTest.assertTrue((boolean)new Path(earDepDir).toFile().exists());
        StandardFilesystemPublishControllerTest.assertEquals((boolean)this.testIsZip(), (boolean)new Path(earDepDir).toFile().isFile());
        this.verifyListRelativePath((IPath)new Path(earDepDir), Arrays.asList(new Path("META-INF/application.xml")), true);
        IPath applicationXml = new Path(earDepDir).append("META-INF/application.xml");
        Path earDep = new Path(earDepDir);
        IPath deployed = earDep.removeLastSegments(1).append(String.valueOf(earDep.lastSegment()) + ".deployed");
        IPath deployFailed = earDep.removeLastSegments(1).append(String.valueOf(earDep.lastSegment()) + ".failed");
        IPath doDeploy = earDep.removeLastSegments(1).append(String.valueOf(earDep.lastSegment()) + ".dodeploy");
        if (!DeploymentMarkerUtils.supportsJBoss7MarkerDeployment((IServer)this.server)) {
            if (this.isZipped()) {
                return;
            }
            StandardFilesystemPublishControllerTest.assertNotSame((Object)1000, (Object)applicationXml.toFile().lastModified());
            applicationXml.toFile().setLastModified(1000L);
            StandardFilesystemPublishControllerTest.assertEquals((long)1000L, (long)applicationXml.toFile().lastModified());
        } else {
            StandardFilesystemPublishControllerTest.assertFalse((boolean)deployed.toFile().exists());
            StandardFilesystemPublishControllerTest.assertFalse((boolean)deployFailed.toFile().exists());
            deployed.toFile().createNewFile();
            deployFailed.toFile().createNewFile();
            StandardFilesystemPublishControllerTest.assertTrue((boolean)deployed.toFile().exists());
            StandardFilesystemPublishControllerTest.assertTrue((boolean)deployFailed.toFile().exists());
        }
        controller.publishFinish((IProgressMonitor)new NullProgressMonitor());
        if (!DeploymentMarkerUtils.supportsJBoss7MarkerDeployment((IServer)this.server)) {
            StandardFilesystemPublishControllerTest.assertNotSame((Object)1000, (Object)applicationXml.toFile().lastModified());
        } else {
            StandardFilesystemPublishControllerTest.assertFalse((boolean)deployed.toFile().exists());
            StandardFilesystemPublishControllerTest.assertFalse((boolean)deployFailed.toFile().exists());
            StandardFilesystemPublishControllerTest.assertTrue((boolean)doDeploy.toFile().exists());
        }
    }

    private void utilInWebInEarRemovals_verifyWeb(String webDepDir, String earDepDir, boolean shouldExist) {
        if (!this.testIsZip()) {
            StandardFilesystemPublishControllerTest.assertTrue((boolean)new Path(webDepDir).toFile().exists());
            StandardFilesystemPublishControllerTest.assertEquals((boolean)false, (boolean)new Path(webDepDir).toFile().isFile());
            this.verifyListRelativePath((IPath)new Path(webDepDir), Arrays.asList(new Path("index.html")), true);
        } else {
            IPath webRelToEar = new Path(webDepDir).removeFirstSegments(new Path(earDepDir).segmentCount());
            this.verifyListRelativePath((IPath)new Path(earDepDir), Arrays.asList(webRelToEar.append("index.html")), true);
        }
    }

    private void utilInWebInEarRemovals_verifyUtil(String utilDepDir, String earDepDir, boolean shouldExist) {
        ServerExtendedProperties props = ExtendedServerPropertiesAdapterFactory.getServerExtendedProperties((IServerAttributes)this.server);
        StandardFilesystemPublishControllerTest.assertNotNull((Object)props);
        boolean allowExplodedUtil = props.allowExplodedModulesInWarLibs();
        if (!this.testIsZip()) {
            StandardFilesystemPublishControllerTest.assertEquals((boolean)shouldExist, (boolean)new Path(utilDepDir).toFile().exists());
            boolean shouldBeFile = !allowExplodedUtil && shouldExist;
            StandardFilesystemPublishControllerTest.assertEquals((boolean)shouldBeFile, (boolean)new Path(utilDepDir).toFile().isFile());
            this.verifyListRelativePath((IPath)new Path(utilDepDir), Arrays.asList(new Path("Main.class")), shouldExist);
        } else {
            IPath utilRelToEar = new Path(utilDepDir).removeFirstSegments(new Path(earDepDir).segmentCount());
            this.verifyListRelativePath((IPath)new Path(earDepDir), Arrays.asList(utilRelToEar.append("Main.class")), shouldExist);
        }
    }

    @Test
    public void testUtilInWebInEarRemovals() throws Exception {
        this.testUtilInWebInEarMockModule();
        CustomPublishController controller = new CustomPublishController();
        controller.initialize((IServerAttributes)this.server, null, null);
        ((MockModule)this.module[1]).clearChildren();
        int result = controller.publishModule(1, 2, new IModule[]{this.module[0]}, null);
        StandardFilesystemPublishControllerTest.assertEquals((int)result, (int)1);
        int resultWeb = controller.publishModule(1, 2, new IModule[]{this.module[0], this.module[1]}, null);
        StandardFilesystemPublishControllerTest.assertEquals((int)resultWeb, (int)1);
        int resultUtil = controller.publishModule(1, 3, this.module, null);
        StandardFilesystemPublishControllerTest.assertEquals((int)resultUtil, (int)1);
        String earDepDir = controller.getDeployPathController().getDeployDirectory(new IModule[]{this.module[0]}).toOSString();
        StandardFilesystemPublishControllerTest.assertTrue((boolean)new Path(earDepDir).toFile().exists());
        StandardFilesystemPublishControllerTest.assertEquals((boolean)this.testIsZip(), (boolean)new Path(earDepDir).toFile().isFile());
        this.verifyListRelativePath((IPath)new Path(earDepDir), Arrays.asList(new Path("META-INF/application.xml")), true);
        String webDepDir = controller.getDeployPathController().getDeployDirectory(new IModule[]{this.module[0], this.module[1]}).toOSString();
        this.utilInWebInEarRemovals_verifyWeb(webDepDir, earDepDir, true);
        String utilDepDir = controller.getDeployPathController().getDeployDirectory(this.module).toOSString();
        this.utilInWebInEarRemovals_verifyUtil(utilDepDir, earDepDir, false);
        ((MockModule)this.module[0]).clearChildren();
        result = controller.publishModule(1, 2, new IModule[]{this.module[0]}, null);
        StandardFilesystemPublishControllerTest.assertEquals((int)result, (int)1);
        resultWeb = controller.publishModule(1, 3, new IModule[]{this.module[0], this.module[1]}, null);
        StandardFilesystemPublishControllerTest.assertEquals((int)resultWeb, (int)1);
        StandardFilesystemPublishControllerTest.assertTrue((boolean)new Path(earDepDir).toFile().exists());
        StandardFilesystemPublishControllerTest.assertEquals((boolean)this.testIsZip(), (boolean)new Path(earDepDir).toFile().isFile());
        this.verifyListRelativePath((IPath)new Path(earDepDir), Arrays.asList(new Path("META-INF/application.xml")), true);
        this.utilInWebInEarRemovals_verifyWeb(webDepDir, earDepDir, false);
    }

    private boolean testIsZip() {
        return this.param_zip.equals("zipped");
    }

    private IModuleResourceDelta[] createDelta(IModule m) throws CoreException {
        ArrayList<IModuleResource> l = new ArrayList<IModuleResource>();
        IModuleResource[] all = MockModuleUtil.getAllResources(this.getResources(m));
        l.addAll(Arrays.asList(all));
        return MockModuleUtil.createMockResourceDeltas(l);
    }

    private IModuleResource[] getResources(IModule m) throws CoreException {
        ModuleDelegate md = (ModuleDelegate)m.loadAdapter(ModuleDelegate.class, null);
        return md.members();
    }

    private IPath setUnderlyingVersion(int v) throws Exception {
        IPath underlying = ASMatrixTests.getDefault().getStateLocation().append("underlying.txt");
        underlying.toFile().getParentFile().mkdirs();
        IOUtil.setContents(underlying.toFile(), "version" + v);
        return underlying;
    }

    private IPath[] getLeafPaths() {
        IPath[] leafs = new IPath[]{new Path("w"), new Path("x"), new Path("y"), new Path("z"), new Path("a/a1"), new Path("a/a2"), new Path("a/q1"), new Path("a/q2"), new Path("b/b1"), new Path("b/b2"), new Path("b/b3"), new Path("b/b4"), new Path("c/y1"), new Path("c/y2.png"), new Path("c/y3.jpg"), new Path("c/y4.pdf"), new Path("d/F/f1.jar"), new Path("d/F/f2.txt"), new Path("d/F/f3.txt"), new Path("d/F/f4.txt")};
        return leafs;
    }

    private MockModule[] createSimpleMockWebModule() throws Exception {
        IPath underlying = this.setUnderlyingVersion(1);
        MockModule m = MockModuleUtil.createMockWebModule();
        IPath[] leafs = this.getLeafPaths();
        IModuleResource[] all = MockModuleUtil.createMockResources(leafs, new IPath[0], underlying.toFile());
        m.setMembers(all);
        m.setExists(true);
        return new MockModule[]{m};
    }

    private MockModule[] createSimpleMockBinaryWebModule() throws Exception {
        IPath underlying = this.setUnderlyingVersion(1);
        MockModule m = MockModuleUtil.createMockWebModule();
        IPath[] leafs = new IPath[]{new Path("some.war")};
        IModuleResource[] all = MockModuleUtil.createMockResources(leafs, new IPath[0], underlying.toFile());
        m.setMembers(all);
        m.setExists(true);
        return new MockModule[]{m};
    }

    private MockModule[] createUtilInWebMockModule() throws Exception {
        IPath underlying = this.setUnderlyingVersion(1);
        MockModule web = MockModuleUtil.createMockWebModule();
        MockModule util = MockModuleUtil.createMockUtilModule();
        String utilWithSuffix = String.valueOf(util.getName()) + ".jar";
        String warWithSuffix = String.valueOf(web.getName()) + ".war";
        String uri = "nested/inside/" + utilWithSuffix;
        web.addChildModule(util, uri);
        MockModule[] utilInWeb = new MockModule[]{web, util};
        IPath[] webLeafs = new IPath[]{new Path("index.html")};
        IPath[] utilLeafs = new IPath[]{new Path("Main.class")};
        IModuleResource[] webResources = MockModuleUtil.createMockResources(webLeafs, new IPath[0], underlying.toFile());
        IModuleResource[] utilResources = MockModuleUtil.createMockResources(utilLeafs, new IPath[0], underlying.toFile());
        web.setMembers(webResources);
        util.setMembers(utilResources);
        return utilInWeb;
    }

    private MockModule[] createDifferentURIBinaryUtilInWebMockModule(String utilFileName, String utilNestedName) throws Exception {
        IPath underlying = this.setUnderlyingVersion(1);
        MockModule web = MockModuleUtil.createMockWebModule();
        MockModule util = MockModuleUtil.createMockUtilModule();
        util.setBinary(true);
        String utilWithSuffix = utilNestedName;
        String warWithSuffix = String.valueOf(web.getName()) + ".war";
        String uri = "nested/inside/" + utilWithSuffix;
        web.addChildModule(util, uri);
        MockModule[] utilInWeb = new MockModule[]{web, util};
        IPath[] webLeafs = new IPath[]{new Path("index.html")};
        IPath[] utilLeafs = new IPath[]{new Path(utilFileName)};
        IModuleResource[] webResources = MockModuleUtil.createMockResources(webLeafs, new IPath[0], underlying.toFile());
        IModuleResource[] utilResources = MockModuleUtil.createMockResources(utilLeafs, new IPath[0], underlying.toFile());
        web.setMembers(webResources);
        util.setMembers(utilResources);
        return utilInWeb;
    }

    private MockModule[] createUtilInWebInEarMockModule() throws Exception {
        IPath underlying = this.setUnderlyingVersion(1);
        MockModule ear = MockModuleUtil.createMockEarModule();
        MockModule web = MockModuleUtil.createMockWebModule();
        MockModule util = MockModuleUtil.createMockUtilModule();
        String utilWithSuffix = String.valueOf(util.getName()) + ".jar";
        String warWithSuffix = String.valueOf(web.getName()) + ".war";
        String earWithSuffix = String.valueOf(ear.getName()) + ".ear";
        String utilUri = "nested/inside/" + utilWithSuffix;
        web.addChildModule(util, utilUri);
        ear.addChildModule(web, warWithSuffix);
        MockModule[] utilInWebInEar = new MockModule[]{ear, web, util};
        IPath[] earLeafs = new IPath[]{new Path("META-INF/application.xml")};
        IPath[] webLeafs = new IPath[]{new Path("index.html")};
        IPath[] utilLeafs = new IPath[]{new Path("Main.class")};
        IModuleResource[] earResources = MockModuleUtil.createMockResources(earLeafs, new IPath[0], underlying.toFile());
        IModuleResource[] webResources = MockModuleUtil.createMockResources(webLeafs, new IPath[0], underlying.toFile());
        IModuleResource[] utilResources = MockModuleUtil.createMockResources(utilLeafs, new IPath[0], underlying.toFile());
        ear.setMembers(earResources);
        web.setMembers(webResources);
        util.setMembers(utilResources);
        return utilInWebInEar;
    }

    protected void verifyListRelativePath(IPath root, List<IPath> list, boolean exists) {
        ArrayList<IPath> list2 = new ArrayList<IPath>();
        Iterator<IPath> i = list.iterator();
        while (i.hasNext()) {
            list2.add(root.append(i.next()));
        }
        super.verifyList(root, list2, exists);
    }
}

