/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.itests;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.HashSet;
import junit.framework.AssertionFailedError;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.launching.JavaRuntime;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.IRuntimeWorkingCopy;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerType;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.internal.ServerWorkingCopy;
import org.jboss.ide.eclipse.archives.core.ArchivesCore;
import org.jboss.ide.eclipse.archives.core.model.ArchivesModel;
import org.jboss.ide.eclipse.archives.core.model.IArchive;
import org.jboss.ide.eclipse.archives.core.model.IArchiveModelRootNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveNode;
import org.jboss.ide.eclipse.archives.core.model.IArchiveStandardFileSet;
import org.jboss.ide.eclipse.archives.ui.actions.BuildAction;
import org.jboss.ide.eclipse.archives.webtools.modules.ArchivesModuleModelListener;
import org.jboss.tools.as.itests.Activator;
import org.jboss.tools.test.util.JobUtils;

public class ProjectArchivesBuildDeployTest
extends TestCase {
    private static final String VALUE_PREFIX = "value";
    private static final String OUT_JAR = "out.jar";
    private static final String FILE_NAME = "a.txt";
    private int index = 0;
    private IProject project;
    private IJavaProject javaProject;
    private IRuntime runtime;
    private IServer server;
    private IPath deploy;
    private IPath tempDeploy;
    private IPath pluginMetadata;
    private IFile textFile;
    private IFile textOutputFile;
    private IFile textBuildArchiveFile;
    private File textDeployedFile;
    private IArchive rootArchive;

    public void testBuildDeploy() throws Exception {
        this.enableAutomaticBuilder(false);
        this.createProject();
        this.setupServer();
        this.addArchives();
        this.buildArchive();
        this.assertBuiltArchiveContents(this.index);
        this.changeArchivesDeployPrefs(false, this.server.getId());
        this.deploy();
        this.assertDeployContents(this.index);
        this.enableAutomaticBuilder(true);
        int count = ++this.index;
        this.setContents(count);
        this.callBuild();
        this.assertSourceContents(count);
        this.assertBinContents(count);
        this.assertBuiltArchiveContents(count);
        try {
            this.assertDeployContents(count);
            ProjectArchivesBuildDeployTest.assertTrue((String)"Deployed File should not have changed", (boolean)false);
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
        this.changeArchivesDeployPrefs(true, this.server.getId());
        count = ++this.index;
        try {
            Thread.sleep(3000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.waitForIdle();
        this.setContents(count);
        this.callBuild();
        this.assertSourceContents(count);
        this.assertBinContents(count);
        this.assertBuiltArchiveContents(count);
        this.assertDeployContents(count);
        count = ++this.index;
        this.setContents(count);
        this.assertSourceContents(count);
        try {
            this.assertBinContents(count);
            ProjectArchivesBuildDeployTest.assertTrue((String)"Bin File should not have changed", (boolean)false);
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
        try {
            this.assertBuiltArchiveContents(count);
            ProjectArchivesBuildDeployTest.assertTrue((String)"Built Archive File should not have changed", (boolean)false);
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
        try {
            this.assertDeployContents(count);
            ProjectArchivesBuildDeployTest.assertTrue((String)"Deployed File should not have changed", (boolean)false);
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
        this.callBuild();
        this.assertBinContents(count);
        this.assertBuiltArchiveContents(count);
        this.assertDeployContents(count);
    }

    protected void enableAutomaticBuilder(boolean enabled) throws CoreException {
        IWorkspaceDescription desc = ResourcesPlugin.getWorkspace().getDescription();
        desc.setAutoBuilding(enabled);
        ResourcesPlugin.getWorkspace().setDescription(desc);
    }

    protected void createProject() throws CoreException, IOException {
        this.javaProject = this.createJavaProject("P1");
        this.project = this.javaProject.getProject();
        this.textFile = this.project.getFile((IPath)new Path(FILE_NAME));
        this.textOutputFile = this.project.getFile(new Path("bin").append(FILE_NAME));
        String initial = VALUE_PREFIX + this.index;
        ProjectArchivesBuildDeployTest.assertFalse((boolean)this.textFile.getLocation().toFile().exists());
        this.textFile.create((InputStream)new ByteArrayInputStream(initial.getBytes()), true, (IProgressMonitor)new NullProgressMonitor());
        ProjectArchivesBuildDeployTest.assertTrue((boolean)this.textFile.getLocation().toFile().exists());
        ProjectArchivesBuildDeployTest.assertFalse((boolean)this.textOutputFile.getLocation().toFile().exists());
        this.callBuild();
        ProjectArchivesBuildDeployTest.assertTrue((boolean)this.textOutputFile.getLocation().toFile().exists());
        this.assertContents(this.textOutputFile.getContents(), this.index);
        this.setContents(++this.index);
        this.assertContents(this.textFile.getContents(), this.index);
        this.assertContents(this.textOutputFile.getContents(), 0);
        ResourcesPlugin.getWorkspace().build(10, (IProgressMonitor)new NullProgressMonitor());
        this.assertContents(this.textOutputFile.getContents(), 1);
    }

    protected String getContents(InputStream is) throws IOException {
        BufferedInputStream bis = new BufferedInputStream(is);
        int l = (int)this.textOutputFile.getLocation().toFile().length();
        byte[] bs = new byte[l];
        l = bis.read(bs, 0, l);
        bis.close();
        return new String(bs);
    }

    protected IJavaProject createJavaProject(String name) {
        try {
            IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
            IProject project = root.getProject(name);
            project.create((IProgressMonitor)new NullProgressMonitor());
            project.open((IProgressMonitor)new NullProgressMonitor());
            IProjectDescription description = project.getDescription();
            String[] natures = description.getNatureIds();
            String[] newNatures = new String[natures.length + 1];
            System.arraycopy(natures, 0, newNatures, 0, natures.length);
            newNatures[natures.length] = "org.eclipse.jdt.core.javanature";
            description.setNatureIds(newNatures);
            project.setDescription(description, (IProgressMonitor)new NullProgressMonitor());
            IJavaProject javaProject = JavaCore.create((IProject)project);
            HashSet<IClasspathEntry> entries = new HashSet<IClasspathEntry>();
            entries.addAll(Arrays.asList(javaProject.getRawClasspath()));
            entries.add(JavaRuntime.getDefaultJREContainerEntry());
            IClasspathEntry[] entries2 = entries.toArray(new IClasspathEntry[entries.size()]);
            javaProject.setRawClasspath(entries2, (IProgressMonitor)new NullProgressMonitor());
            return javaProject;
        }
        catch (CoreException coreException) {
            return null;
        }
    }

    protected void setupServer() throws CoreException {
        int initialServerCount = ServerCore.getServers().length;
        int initialRuntimeCount = ServerCore.getRuntimes().length;
        this.pluginMetadata = Activator.getDefault().getStateLocation();
        this.pluginMetadata.toFile().mkdirs();
        this.pluginMetadata.append("server1").toFile().mkdirs();
        this.deploy = this.pluginMetadata.append("server1").append("1");
        this.deploy.toFile().mkdirs();
        this.tempDeploy = this.pluginMetadata.append("server1").append("2");
        this.tempDeploy.toFile().mkdirs();
        IRuntimeType[] rtTypes = ServerCore.getRuntimeTypes();
        IRuntimeType rtType = null;
        int i = 0;
        while (i < rtTypes.length) {
            if (rtTypes[i].getId().equals("org.jboss.ide.eclipse.as.runtime.stripped")) {
                rtType = rtTypes[i];
            }
            ++i;
        }
        ProjectArchivesBuildDeployTest.assertNotNull(rtType);
        IRuntimeWorkingCopy rtwc = rtType.createRuntime("temp.rt.id", (IProgressMonitor)new NullProgressMonitor());
        this.runtime = rtwc.save(true, (IProgressMonitor)new NullProgressMonitor());
        IServerType[] serverTypes = ServerCore.getServerTypes();
        IServerType serverType = null;
        int i2 = 0;
        while (i2 < serverTypes.length) {
            if (serverTypes[i2].getId().equals("org.jboss.ide.eclipse.as.systemCopyServer")) {
                serverType = serverTypes[i2];
            }
            ++i2;
        }
        ProjectArchivesBuildDeployTest.assertNotNull(serverType);
        IServerWorkingCopy wc = serverType.createServer("tmp.server.id", null, (IProgressMonitor)new NullProgressMonitor());
        if (wc instanceof ServerWorkingCopy) {
            ServerWorkingCopy swc = (ServerWorkingCopy)wc;
            swc.setName("server1");
            swc.setAttribute("org.jboss.ide.eclipse.as.core.server.deployDirectory", this.deploy.toOSString());
            swc.setAttribute("org.jboss.ide.eclipse.as.core.server.tempDeployDirectory", this.tempDeploy.toOSString());
            swc.setRuntime(this.runtime);
            swc.setAutoPublishTime(1);
            swc.setAutoPublishSetting(2);
        }
        this.server = wc.save(true, (IProgressMonitor)new NullProgressMonitor());
        ProjectArchivesBuildDeployTest.assertEquals((int)ServerCore.getRuntimes().length, (int)(initialRuntimeCount + 1));
        ProjectArchivesBuildDeployTest.assertEquals((int)ServerCore.getServers().length, (int)(initialServerCount + 1));
        this.textDeployedFile = this.deploy.append(OUT_JAR).append(FILE_NAME).toFile();
    }

    protected void addArchives() {
        ArchivesModel.instance().registerProject(this.project.getLocation(), (IProgressMonitor)new NullProgressMonitor());
        IArchiveModelRootNode root = ArchivesModel.instance().getRoot(this.project.getLocation());
        this.rootArchive = ArchivesCore.getInstance().getNodeFactory().createArchive();
        this.rootArchive.setExploded(true);
        this.rootArchive.setInWorkspace(true);
        this.rootArchive.setName(OUT_JAR);
        this.rootArchive.setDestinationPath(null);
        root.addChild((IArchiveNode)this.rootArchive);
        IArchiveStandardFileSet fs = ArchivesCore.getInstance().getNodeFactory().createFileset();
        fs.setIncludesPattern("**/*txt");
        fs.setExcludesPattern("**/bin/**, **/*jar*");
        fs.setInWorkspace(true);
        fs.setRawSourcePath("/P1");
        this.rootArchive.addChild((IArchiveNode)fs);
        root.save((IProgressMonitor)new NullProgressMonitor());
        this.textBuildArchiveFile = this.project.getFolder(OUT_JAR).getFile(FILE_NAME);
    }

    protected void changeArchivesDeployPrefs(boolean alwaysPublish, String servers) {
        this.rootArchive.setProperty("org.jboss.ide.eclipse.as.core.model.PackagesListener.DeployServers", servers);
        this.rootArchive.setProperty("org.jboss.ide.eclipse.as.core.model.PackagesListener.DeployAfterBuild", new Boolean(alwaysPublish).toString());
        IPath projectPath = this.rootArchive.getProjectPath();
        ArchivesModel.instance().getRoot(projectPath).save((IProgressMonitor)new NullProgressMonitor());
    }

    protected void buildArchive() {
        Job j = new BuildAction().run((Object)this.rootArchive);
        this.waitForIdle();
        ProjectArchivesBuildDeployTest.assertTrue((boolean)j.getResult().isOK());
    }

    protected void deploy() {
        ArchivesModuleModelListener.getInstance().publish(this.rootArchive, this.server.getId(), 2);
    }

    protected void setContents(int val) throws IOException, CoreException {
        this.textFile.setContents((InputStream)new ByteArrayInputStream(new String(VALUE_PREFIX + val).getBytes()), false, false, (IProgressMonitor)new NullProgressMonitor());
        try {
            Thread.sleep(2000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.waitForIdle();
    }

    protected void assertContents(InputStream is, int val) throws IOException {
        String contents = this.getContents(is);
        ProjectArchivesBuildDeployTest.assertEquals((String)(VALUE_PREFIX + val), (String)contents);
    }

    protected void assertSourceContents(int val) throws IOException, CoreException {
        this.assertContents(this.textFile.getContents(), val);
    }

    protected void assertBinContents(int val) throws IOException, CoreException {
        this.assertContents(this.textOutputFile.getContents(), val);
    }

    protected void assertBuiltArchiveContents(int val) throws IOException, CoreException {
        this.assertContents(this.textBuildArchiveFile.getContents(), val);
    }

    protected void assertDeployContents(int val) throws IOException, CoreException {
        this.assertContents(new FileInputStream(this.textDeployedFile), val);
    }

    protected void callBuild() throws CoreException {
        ResourcesPlugin.getWorkspace().build(10, (IProgressMonitor)new NullProgressMonitor());
        this.waitForIdle();
        ResourcesPlugin.getWorkspace().getRoot().refreshLocal(2, (IProgressMonitor)new NullProgressMonitor());
        this.waitForIdle();
    }

    private void waitForIdle() {
        JobUtils.waitForIdle((long)2500L);
    }
}

