/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.itests;

import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import org.jboss.ide.eclipse.as.core.server.bean.JBossServerType;
import org.jboss.ide.eclipse.as.core.util.IJBossToolingConstants;
import org.jboss.tools.as.test.core.TestConstants;
import org.jboss.tools.as.test.core.internal.utils.ServerParameterUtils;
import org.jboss.tools.as.test.core.parametized.server.ServerBeanLoader3Test;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class ServerBeanLoaderIntegrationTest
extends ServerBeanLoader3Test {
    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        return ServerParameterUtils.asCollection((Object[])ServerParameterUtils.getJBossServerTypeParametersPlusAdditionalMocks());
    }

    public ServerBeanLoaderIntegrationTest(String serverType) {
        super(serverType);
    }

    @Before
    public void setUp() {
        super.setUp();
    }

    @Test
    public void testServerBeanLoaderFromRuntimes() {
        String fLoc = TestConstants.getServerHome((String)this.serverType);
        if (fLoc == null) {
            if (Arrays.asList(IJBossToolingConstants.ALL_JBOSS_SERVERS).contains(this.serverType)) {
                ServerBeanLoaderIntegrationTest.fail((String)("Test Suite has no server home for server type " + this.serverType));
            }
            return;
        }
        ServerBeanLoader3Test.Data p = (ServerBeanLoader3Test.Data)this.expected.get(this.serverType);
        this.inner_testServerBeanLoaderForFolder(new File(fLoc), p.type, p.version, p.overrideId);
        if (p.type.equals(JBossServerType.EAP_STD)) {
            this.inner_testServerBeanLoaderForFolder(new File(fLoc).getParentFile(), JBossServerType.EAP, p.version, p.overrideId);
        }
    }
}

