/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.tools.as.itests.server.publishing;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import junit.framework.TestCase;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jst.j2ee.application.internal.operations.AddReferenceToEnterpriseApplicationDataModelProvider;
import org.eclipse.wst.common.componentcore.ComponentCore;
import org.eclipse.wst.common.componentcore.internal.resources.VirtualReference;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;
import org.eclipse.wst.common.frameworks.datamodel.IDataModel;
import org.eclipse.wst.common.frameworks.datamodel.IDataModelProvider;
import org.eclipse.wst.common.project.facet.core.IProjectFacetVersion;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.model.IModuleFile;
import org.jboss.tools.as.test.core.ASMatrixTests;
import org.jboss.tools.as.test.core.internal.utils.ComponentReferenceUtils;
import org.jboss.tools.as.test.core.internal.utils.ResourceUtils;
import org.jboss.tools.as.test.core.internal.utils.wtp.CreateProjectOperationsUtility;
import org.jboss.tools.as.test.core.internal.utils.wtp.JavaEEFacetConstants;
import org.jboss.tools.as.test.core.internal.utils.wtp.OperationTestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class DeploymentAssemblyFilesetReferenceTest
extends TestCase {
    private static String PROJECT_PREFIX = "q40Ear";
    private static int PROJECT_ID = 1;
    private String MY_PROJECT_NAME;

    @After
    public void tearDown() throws Exception {
        ASMatrixTests.cleanup();
    }

    @Before
    public void setUp() throws Exception {
        this.MY_PROJECT_NAME = String.valueOf(PROJECT_PREFIX) + ++PROJECT_ID;
        IDataModel dm = CreateProjectOperationsUtility.getEARDataModel((String)this.MY_PROJECT_NAME, (String)"ourContent", null, null, (IProjectFacetVersion)JavaEEFacetConstants.EAR_5, (boolean)false);
        OperationTestCase.runAndVerify((IDataModel)dm);
        IProject p = ResourceUtils.findProject((String)this.MY_PROJECT_NAME);
        if (!p.exists()) {
            DeploymentAssemblyFilesetReferenceTest.fail();
        }
        p.getFolder("folder1").create(true, true, (IProgressMonitor)new NullProgressMonitor());
        p.getFolder("folder2").create(true, true, (IProgressMonitor)new NullProgressMonitor());
        p.getFolder("folder3").create(true, true, (IProgressMonitor)new NullProgressMonitor());
        this.createFile(p, "folder1", "a", "contents1");
        this.createFile(p, "folder1", "b", "contents1");
        this.createFile(p, "folder1", "z", "contents1");
        this.createFile(p, "folder2", "c", "contents1");
        this.createFile(p, "folder2", "d", "contents1");
        this.createFile(p, "folder2", "z", "contents1");
        this.createFile(p, "folder3", "d", "contents1");
        this.createFile(p, "folder3", "e", "contents1");
        this.createFile(p, "folder3", "z", "contents1");
    }

    private void createFile(IProject project, String folder, String filename, String contents) throws CoreException {
        IFolder f = project.getFolder(folder);
        IFile f2 = f.getFile(filename);
        ByteArrayInputStream is = new ByteArrayInputStream(contents.getBytes());
        f2.create((InputStream)is, true, (IProgressMonitor)new NullProgressMonitor());
    }

    @Test
    public void testRootFolder() throws Exception {
        this.runTest(this.MY_PROJECT_NAME, "**", ".settings/**", "/", 9);
    }

    @Test
    public void testRootFolderExcludeZ() throws Exception {
        this.runTest(this.MY_PROJECT_NAME, "**", ".settings/**,**/z*", "/", 6);
    }

    @Test
    public void testFolderOneOnly() throws Exception {
        this.runTest(this.MY_PROJECT_NAME, "folder1/**", "", "/", 3);
    }

    @Test
    public void testFolderTwoOnly() throws Exception {
        this.runTest(this.MY_PROJECT_NAME, "folder2/**", "", "/", 3);
    }

    @Test
    public void testFolderThreeOnly() throws Exception {
        this.runTest(this.MY_PROJECT_NAME, "folder3/**", "", "/", 3);
    }

    @Test
    public void testZsOnly() throws Exception {
        this.runTest(this.MY_PROJECT_NAME, "**/z", "", "/", 3);
    }

    private void runTest(String rootFolder, String inc, String exc, String runtimePath, int expectedCount) throws CoreException {
        IProject p = ResourceUtils.findProject((String)this.MY_PROJECT_NAME);
        System.out.println(p.getLocation());
        IVirtualComponent root = ComponentCore.createComponent((IProject)p);
        VirtualReference ref = ComponentReferenceUtils.createFilesetComponentReference((IVirtualComponent)root, (String)rootFolder, (String)inc, (String)exc, (String)runtimePath);
        ComponentReferenceUtils.addReferenceToComponent((IVirtualComponent)root, (IVirtualReference)ref, (IDataModelProvider)new AddReferenceToEnterpriseApplicationDataModelProvider());
        IModule module = ServerUtil.getModule((IProject)p);
        IModuleFile[] allFiles = ResourceUtils.findAllIModuleFiles((IModule)module);
        DeploymentAssemblyFilesetReferenceTest.assertEquals((int)allFiles.length, (int)expectedCount);
    }
}

