/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.wst.server.core.IRuntime;
import org.jboss.ide.eclipse.as.classpath.core.ClasspathCorePlugin;
import org.jboss.ide.eclipse.as.classpath.core.internal.Messages;
import org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal.ProjectRuntimeKey;
import org.jboss.ide.eclipse.as.core.server.IJBossServerRuntime;

public class ProjectRuntimeClasspathCache {
    private static ProjectRuntimeClasspathCache instance = null;
    private Map<ProjectRuntimeKey, IClasspathEntry[]> runtimeClasspaths = new HashMap<ProjectRuntimeKey, IClasspathEntry[]>();

    public static ProjectRuntimeClasspathCache getInstance() {
        if (instance == null) {
            instance = new ProjectRuntimeClasspathCache();
        }
        return instance;
    }

    ProjectRuntimeClasspathCache() {
    }

    private Map<ProjectRuntimeKey, IClasspathEntry[]> getRuntimeClasspaths() {
        return this.runtimeClasspaths;
    }

    public IClasspathEntry[] getEntries(IProject p, IRuntime rt) {
        return this.getRuntimeClasspaths().get(ProjectRuntimeClasspathCache.getProjectRuntimeKey(p, rt));
    }

    public void cacheEntries(IProject p, IRuntime rt, IClasspathEntry[] entries) {
        this.getRuntimeClasspaths().put(ProjectRuntimeClasspathCache.getProjectRuntimeKey(p, rt), entries);
    }

    static ProjectRuntimeKey getProjectRuntimeKey(IProject project, IRuntime runtime) {
        if (runtime == null) {
            ProjectRuntimeClasspathCache.logError(runtime);
            return null;
        }
        IJBossServerRuntime jbsrt = (IJBossServerRuntime)runtime.loadAdapter(IJBossServerRuntime.class, (IProgressMonitor)new NullProgressMonitor());
        if (jbsrt == null) {
            ProjectRuntimeClasspathCache.logError(runtime);
            return null;
        }
        IPath loc = runtime.getLocation();
        String rtID = runtime.getRuntimeType().getId();
        IPath configPath = jbsrt == null ? null : jbsrt.getConfigurationFullPath();
        return new ProjectRuntimeKey(project, loc, configPath, rtID);
    }

    private static void logError(IRuntime runtime) {
        Status status = new Status(2, "org.jboss.ide.eclipse.as.classpath.core", MessageFormat.format(Messages.ClientAllRuntimeClasspathProvider_wrong_runtime_type, runtime == null ? null : runtime.getName()));
        ClasspathCorePlugin.getDefault().getLog().log((IStatus)status);
    }
}

