/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;
import org.eclipse.wst.server.core.IRuntimeType;
import org.jboss.ide.eclipse.as.classpath.core.ClasspathCorePlugin;
import org.jboss.ide.eclipse.as.classpath.core.internal.Messages;
import org.jboss.ide.eclipse.as.classpath.core.runtime.IRuntimePathProvider;
import org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal.InternalRuntimeClasspathModel;
import org.jboss.ide.eclipse.as.classpath.core.runtime.path.internal.Fileset;
import org.jboss.ide.eclipse.as.classpath.core.runtime.path.internal.LayeredProductPathProvider;
import org.jboss.ide.eclipse.as.classpath.core.runtime.path.internal.RuntimePathProviderFileset;
import org.jboss.ide.eclipse.as.core.JBossServerCorePlugin;
import org.jboss.tools.foundation.core.xml.IMemento;
import org.jboss.tools.foundation.core.xml.XMLMemento;

public class RuntimeClasspathModelIO {
    protected static final IPath DEFAULT_CLASSPATH_FS_ROOT = JBossServerCorePlugin.getGlobalSettingsLocation().append("filesets").append("runtimeClasspaths");
    protected static final String VERSION = "version";

    public InternalRuntimeClasspathModel readModel(IRuntimeType rtt) {
        return this.loadPathProviders(rtt);
    }

    private InternalRuntimeClasspathModel loadPathProviders(IRuntimeType rt) {
        IPath fileToRead = DEFAULT_CLASSPATH_FS_ROOT.append(rt.getId());
        File f = fileToRead.toFile();
        if (f != null && f.exists()) {
            try {
                FileInputStream fis = new FileInputStream(f);
                XMLMemento memento = XMLMemento.createReadRoot((InputStream)fis);
                String version = memento.getString(VERSION);
                InternalRuntimeClasspathModel model = new InternalRuntimeClasspathModel();
                if (version == null) {
                    this.fillVersion1PathProviders(model, memento);
                } else if ("2.0".equals(version)) {
                    this.fillVersion2PathProviders(model, memento);
                }
                return model;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private IRuntimePathProvider layeredProduct(XMLMemento layeredProductMemento) {
        String modName = layeredProductMemento.getString("moduleName");
        String slot = layeredProductMemento.getString("slot");
        return new LayeredProductPathProvider(modName, slot);
    }

    private IRuntimePathProvider fileset(XMLMemento filesetStyleMemento) {
        String name = filesetStyleMemento.getString("name");
        String folder = filesetStyleMemento.getString("folder");
        String includes = filesetStyleMemento.getString("includes");
        String excludes = filesetStyleMemento.getString("excludes");
        return new RuntimePathProviderFileset(new Fileset(name, folder, includes, excludes));
    }

    private IRuntimePathProvider[] loadProvidersFromMemento(XMLMemento parent) {
        IMemento[] children = parent.getChildren();
        ArrayList<IRuntimePathProvider> collector = new ArrayList<IRuntimePathProvider>();
        int i = 0;
        while (i < children.length) {
            String name = children[i].getNodeName();
            if (name.equals("fileset")) {
                collector.add(this.fileset((XMLMemento)children[i]));
            } else if (name.equals("layeredProductPath")) {
                collector.add(this.layeredProduct((XMLMemento)children[i]));
            }
            ++i;
        }
        IRuntimePathProvider[] list = collector.toArray(new IRuntimePathProvider[collector.size()]);
        return list;
    }

    private void fillVersion1PathProviders(InternalRuntimeClasspathModel model, XMLMemento memento) {
        model.addProviders(this.loadProvidersFromMemento(memento));
    }

    private void fillVersion2PathProviders(InternalRuntimeClasspathModel model, XMLMemento memento) {
        IMemento nofacet = memento.getChild("nofacet");
        IRuntimePathProvider[] noFacetProviders = this.loadProvidersFromMemento((XMLMemento)nofacet);
        model.addProviders(noFacetProviders);
        IMemento[] facets = memento.getChildren("facet");
        int i = 0;
        while (i < facets.length) {
            String id = facets[i].getString("id");
            String version = facets[i].getString(VERSION);
            IRuntimePathProvider[] result = this.loadProvidersFromMemento((XMLMemento)facets[i]);
            model.addProviders(id, version, result);
            ++i;
        }
    }

    public void saveModel(IRuntimeType runtime, InternalRuntimeClasspathModel model) {
        int j;
        if (!DEFAULT_CLASSPATH_FS_ROOT.toFile().exists()) {
            DEFAULT_CLASSPATH_FS_ROOT.toFile().mkdirs();
        }
        IPath fileToWrite = DEFAULT_CLASSPATH_FS_ROOT.append(runtime.getId());
        XMLMemento memento = XMLMemento.createWriteRoot((String)"classpathProviders");
        memento.putString(VERSION, "2.0");
        XMLMemento nofacet = (XMLMemento)memento.createChild("nofacet");
        IRuntimePathProvider[] noFacetProviders = model.getStandardProviders();
        int i = 0;
        while (i < noFacetProviders.length) {
            noFacetProviders[i].saveInMemento(nofacet);
            ++i;
        }
        String[] customized = model.getCustomizedFacets();
        int i2 = 0;
        while (i2 < customized.length) {
            String facetName = customized[i2];
            XMLMemento facet = (XMLMemento)memento.createChild("facet");
            facet.putString("id", facetName);
            IRuntimePathProvider[] providers = model.getProvidersForFacet(facetName);
            j = 0;
            while (j < providers.length) {
                providers[j].saveInMemento(facet);
                ++j;
            }
            ++i2;
        }
        String[] customizedFacetVersions = model.getCustomizedFacetVersions();
        int i3 = 0;
        while (i3 < customized.length) {
            String facetName = customizedFacetVersions[i3];
            String[] versions = model.getCustomizedFacetVersions(facetName);
            j = 0;
            while (j < versions.length) {
                String v = versions[j];
                IRuntimePathProvider[] providers = model.getProvidersForFacet(facetName, v);
                XMLMemento facet = (XMLMemento)memento.createChild("facet");
                facet.putString("id", facetName);
                facet.putString(VERSION, v);
                int k = 0;
                while (k < providers.length) {
                    providers[k].saveInMemento(facet);
                    ++k;
                }
                ++j;
            }
            ++i3;
        }
        try {
            memento.save((OutputStream)new FileOutputStream(fileToWrite.toFile()));
        }
        catch (IOException ioe) {
            Status status = new Status(4, "org.jboss.ide.eclipse.as.classpath.core", NLS.bind((String)Messages.CouldNotSaveDefaultClasspathEntries, (Object)runtime.getId()), (Throwable)ioe);
            ClasspathCorePlugin.getDefault().getLog().log((IStatus)status);
        }
    }
}

