/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.core.runtime.path.internal;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.jboss.ide.eclipse.as.classpath.core.runtime.IRuntimePathProvider;
import org.jboss.ide.eclipse.as.classpath.core.runtime.cache.internal.ModuleSlot;
import org.jboss.tools.foundation.core.expressions.ExpressionResolver;
import org.jboss.tools.foundation.core.expressions.IVariableResolver;
import org.jboss.tools.foundation.core.xml.XMLMemento;

public class LayeredProductPathProvider
implements IRuntimePathProvider {
    public static final String PROP_MODULE_NAME = "moduleName";
    public static final String PROP_SLOT = "slot";
    private IVariableResolver resolver;
    private String moduleName;
    private String slot;

    public LayeredProductPathProvider(String moduleName, String slot) {
        this.moduleName = moduleName;
        this.slot = slot != null && slot.trim().isEmpty() ? null : slot;
    }

    public LayeredProductPathProvider(ModuleSlot ms) {
        this.moduleName = ms.getModule();
        this.slot = ms.getSlot() != null && ms.getSlot().trim().isEmpty() ? null : ms.getSlot();
    }

    public String getModule() {
        return this.moduleName;
    }

    public String getSlot() {
        return this.slot;
    }

    @Override
    public IPath[] getAbsolutePaths() {
        String runtimeHomePattern = "${jboss_server_home}";
        String runtimeHome = new ExpressionResolver(this.resolver).resolve(runtimeHomePattern);
        IPath modulesFolder = new Path(runtimeHome).append("modules");
        return new ModuleSlot(this.moduleName, this.slot).getJars(modulesFolder);
    }

    @Override
    public void setVariableResolver(IVariableResolver resolver) {
        this.resolver = resolver;
    }

    @Override
    public String getDisplayString() {
        return "JBoss Module: " + this.moduleName + " [" + (this.slot == null ? "main" : this.slot) + "]";
    }

    @Override
    public void saveInMemento(XMLMemento memento) {
        XMLMemento child = (XMLMemento)memento.createChild("layeredProductPath");
        child.putString(PROP_MODULE_NAME, this.moduleName);
        child.putString(PROP_SLOT, this.slot == null ? "main" : this.slot);
    }
}

