/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.classpath.ui.containers.custom;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.util.CoreUtility;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.PlatformUI;
import org.eclipse.wst.common.project.facet.core.FacetedProjectFramework;
import org.eclipse.wst.common.project.facet.core.IFacetedProject;
import org.eclipse.wst.common.project.facet.core.ProjectFacetsManager;
import org.eclipse.wst.server.core.IRuntime;
import org.eclipse.wst.server.core.IRuntimeType;
import org.eclipse.wst.server.core.ServerCore;
import org.jboss.ide.eclipse.as.classpath.core.runtime.CustomRuntimeClasspathModel;
import org.jboss.ide.eclipse.as.classpath.core.runtime.IRuntimePathProvider;
import org.jboss.ide.eclipse.as.classpath.ui.Messages;
import org.jboss.ide.eclipse.as.classpath.ui.containers.custom.RuntimeClasspathProviderWizard;
import org.jboss.ide.eclipse.as.ui.preferences.ServerTypePreferencePage;
import org.osgi.service.prefs.BackingStoreException;

public class CustomClasspathPreferencePage
extends ServerTypePreferencePage {
    private static final String LAST_SELECTED_RUNTIME_TYPE = "org.jboss.ide.eclipse.as.classpath.ui.containers.custom.CustomClasspathPreferencePage.LAST_RUNTIME_SELECTED";

    protected Control createContents(Composite parent) {
        this.rootComp = new CustomClasspathPreferenceComposite(parent, 0);
        this.rootComp.setLayoutData((Object)new GridData(1808));
        this.rootComp.layout();
        return this.rootComp;
    }

    public boolean performOk() {
        String[] changed2 = this.rootComp.getChanged();
        final ArrayList<IProject> projectsNeedRefresh = new ArrayList<IProject>();
        int i = 0;
        while (i < changed2.length) {
            String runtimeId = changed2[i];
            IRuntimeType rt = ServerCore.findRuntimeType((String)runtimeId);
            ArrayList list = this.rootComp.getDataForComboSelection(changed2[i]);
            IRuntimePathProvider[] arr = list.toArray(new IRuntimePathProvider[list.size()]);
            CustomRuntimeClasspathModel.getInstance().savePathProviders(rt, arr);
            IProject[] projectsTargeting = this.findProjectsTargeting(rt);
            projectsNeedRefresh.addAll(Arrays.asList(projectsTargeting));
            ++i;
        }
        String lastSelected = this.rootComp.getCurrentId();
        IEclipsePreferences prefs = new InstanceScope().getNode("org.jboss.ide.eclipse.as.ui");
        prefs.put(LAST_SELECTED_RUNTIME_TYPE, lastSelected);
        try {
            prefs.flush();
        }
        catch (BackingStoreException rt) {
            // empty catch block
        }
        MessageDialog dialog = new MessageDialog(this.getShell(), Messages.CustomClasspathsSettingsChanged, null, Messages.CustomClasspathsRequiresRebuild, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.CANCEL_LABEL}, 2);
        int res = dialog.open();
        if (res == 0) {
            WorkspaceJob j = new WorkspaceJob(Messages.CustomClasspathsWorkspaceJob){

                public IStatus runInWorkspace(IProgressMonitor monitor) {
                    Iterator i = projectsNeedRefresh.iterator();
                    monitor.beginTask(Messages.CustomClasspathsWorkspaceJob, projectsNeedRefresh.size());
                    while (i.hasNext()) {
                        IJavaProject jp = JavaCore.create((IProject)((IProject)i.next()));
                        try {
                            jp.setRawClasspath(jp.getRawClasspath(), (IProgressMonitor)new NullProgressMonitor());
                        }
                        catch (JavaModelException jme) {
                            return jme.getStatus();
                        }
                        CoreUtility.getBuildJob((IProject)jp.getProject()).schedule();
                    }
                    monitor.done();
                    return Status.OK_STATUS;
                }
            };
            j.setRule((ISchedulingRule)ResourcesPlugin.getWorkspace().getRoot());
            j.schedule();
        }
        this.rootComp.clearChanged();
        return true;
    }

    private IProject[] findProjectsTargeting(IRuntimeType rt) {
        if (rt == null) {
            return new IProject[0];
        }
        ArrayList<IProject> matching = new ArrayList<IProject>();
        IProject[] allProjs = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int i = 0;
        while (i < allProjs.length) {
            try {
                IRuntime wstRuntime;
                IFacetedProject fp;
                org.eclipse.wst.common.project.facet.core.runtime.IRuntime primary;
                if (allProjs[i].exists() && allProjs[i].isOpen() && FacetedProjectFramework.isFacetedProject((IProject)allProjs[i]) && (primary = (fp = ProjectFacetsManager.create((IProject)allProjs[i])).getPrimaryRuntime()) != null && (wstRuntime = ServerCore.findRuntime((String)primary.getName())).getRuntimeType() != null && wstRuntime.getRuntimeType().getId().equals(rt.getId())) {
                    matching.add(allProjs[i]);
                }
            }
            catch (CoreException coreException) {
                // empty catch block
            }
            ++i;
        }
        return matching.toArray(new IProject[matching.size()]);
    }

    public class CustomClasspathPreferenceComposite
    extends ServerTypePreferencePage.AbstractComboDataPreferenceComposite {
        private IRuntimeType[] types;

        public CustomClasspathPreferenceComposite(Composite parent, int style) {
            super(parent, style);
            this.types = null;
        }

        protected void initializeSelection() {
            IEclipsePreferences prefs = new InstanceScope().getNode("org.jboss.ide.eclipse.as.ui");
            String last = prefs.get(CustomClasspathPreferencePage.LAST_SELECTED_RUNTIME_TYPE, null);
            if (last == null) {
                super.initializeSelection();
            } else {
                IRuntimeType[] types = this.getRuntimeTypes();
                int i = 0;
                while (i < types.length) {
                    if (types[i].getId().equals(last)) {
                        this.combo.select(i);
                        return;
                    }
                    ++i;
                }
            }
        }

        protected LabelProvider getLabelProvider() {
            return new LabelProvider(){

                public Image getImage(Object element) {
                    return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJ_FOLDER");
                }

                public String getText(Object element) {
                    if (element instanceof IRuntimePathProvider) {
                        return ((IRuntimePathProvider)element).getDisplayString();
                    }
                    return super.getText(element);
                }
            };
        }

        public String getDescriptionLabel() {
            return "Set classpath filesets for this runtime type";
        }

        protected Object[] getCurrentComboSelectionDefaultDataModel() {
            String id = this.getCurrentId();
            IRuntimeType rtType = ServerCore.findRuntimeType((String)id);
            Object[] sets = CustomRuntimeClasspathModel.getInstance().getDefaultEntries(rtType);
            return sets;
        }

        protected IRuntimePathProvider[] getCurrentSelectionDataModel() {
            IRuntimeType rtType;
            String id = this.getCurrentId();
            ArrayList<IRuntimePathProvider> list = new ArrayList<IRuntimePathProvider>();
            if (id != null && (list = this.getDataForComboSelection(id)) == null && (rtType = ServerCore.findRuntimeType((String)id)) != null) {
                IRuntimePathProvider[] sets = CustomRuntimeClasspathModel.getInstance().getEntries(rtType);
                list = new ArrayList<IRuntimePathProvider>();
                list.addAll(Arrays.asList(sets));
                this.cacheMap.put(id, list);
            }
            return list.toArray(new IRuntimePathProvider[list.size()]);
        }

        protected String getAllOptionString() {
            return "All Runtime Types";
        }

        private IRuntimeType[] getRuntimeTypes() {
            if (this.types == null) {
                ArrayList<Object> retval = new ArrayList();
                ArrayList<IRuntimeType> all = new ArrayList<IRuntimeType>(Arrays.asList(ServerCore.getRuntimeTypes()));
                if (!this.getAllServerTypes()) {
                    Iterator<IRuntimeType> i = all.iterator();
                    while (i.hasNext()) {
                        IRuntimeType t = i.next();
                        if (t.getId().startsWith("org.jboss.ide.eclipse.as.")) continue;
                        i.remove();
                    }
                }
                retval = all;
                Collections.sort(retval, new Comparator<IRuntimeType>(){

                    @Override
                    public int compare(IRuntimeType o1, IRuntimeType o2) {
                        return o1.getName().compareTo(o2.getName());
                    }
                });
                this.types = all.toArray(new IRuntimeType[all.size()]);
            }
            return this.types;
        }

        protected boolean showAllOption() {
            return false;
        }

        protected String getIdAtIndex(int index) {
            IRuntimeType type = this.getRuntimeTypes()[index];
            String id = type.getId();
            return id;
        }

        protected void addPressed() {
            IRuntimePathProvider ret;
            String id = this.getCurrentId();
            IRuntimeType rtt = id == null ? null : ServerCore.findRuntimeType((String)id);
            RuntimeClasspathProviderWizard wizard = new RuntimeClasspathProviderWizard(rtt);
            WizardDialog wd = new WizardDialog(this.addButton.getShell(), (IWizard)wizard);
            if (wd.open() == 0 && (ret = wizard.getRuntimePathProvider()) != null) {
                this.addObject(ret);
            }
        }

        protected boolean getAllServerTypes() {
            return false;
        }

        protected String[] getComboItemNames() {
            IRuntimeType[] types = this.getRuntimeTypes();
            String[] names = new String[types.length];
            int i = 0;
            while (i < types.length) {
                names[i] = types[i].getName();
                ++i;
            }
            return names;
        }
    }
}

