/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.editor.ports;

import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wst.server.ui.internal.command.ServerCommand;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.dialogs.ChangePortDialog;
import org.jboss.ide.eclipse.as.ui.editor.ports.PortEditorExtension;
import org.jboss.ide.eclipse.as.ui.editor.ports.PortSection;
import org.jboss.ide.eclipse.as.ui.editor.ports.SetPortXPathCommand;

public abstract class PortEditorXPathExtension
extends PortEditorExtension {
    protected Button detect;
    protected Link link;
    protected String currentXPathKey;
    protected String detectXPathKey;
    protected String defaultXPath;
    protected String currentXPath;
    protected int defaultValue;

    public PortEditorXPathExtension(String labelText, String currentXPathKey, String detectXPathKey, String overrideValueKey, String defaultXPath, int defaultValue, String changeValueCommandName) {
        super(labelText, overrideValueKey, defaultValue, changeValueCommandName);
        this.currentXPathKey = currentXPathKey;
        this.detectXPathKey = detectXPathKey;
        this.defaultXPath = defaultXPath;
    }

    @Override
    protected void createUI(Composite parent) {
        this.label = new Label(parent, 0);
        this.text = new Text(parent, 2052);
        this.detect = new Button(parent, 32);
        this.link = new Link(parent, 0);
        GridDataFactory.fillDefaults().align(16384, 0x1000000).applyTo((Control)this.label);
        GridDataFactory.fillDefaults().align(4, 0x1000000).minSize(80, 10).grab(true, false).applyTo((Control)this.text);
        GridDataFactory.fillDefaults().align(0x1000000, 0x1000000).applyTo((Control)this.detect);
        GridDataFactory.fillDefaults().align(131072, 0x1000000).applyTo((Control)this.link);
        this.label.setText(this.labelText);
        this.detect.setText(Messages.EditorAutomaticallyDetectPort);
        this.link.setText("<a href=\"\">" + Messages.Configure + "</a>");
    }

    @Override
    protected void initialize() {
        boolean shouldDetect = this.helper.getAttribute(this.detectXPathKey, true);
        this.detect.setSelection(shouldDetect);
        this.detect.setEnabled(this.defaultXPath != null);
        this.link.setEnabled(shouldDetect);
        this.text.setEnabled(!shouldDetect);
        this.text.setEditable(!shouldDetect);
        this.currentXPath = this.helper.getAttribute(this.currentXPathKey, this.defaultXPath);
        if (shouldDetect) {
            this.text.setText(PortSection.findPortWithDefault(this.helper.getServer(), (IPath)new Path(this.currentXPath), this.defaultValue, this.discoverOffset()));
        } else {
            this.text.setText(this.helper.getAttribute(this.overrideValueKey, ""));
        }
    }

    @Override
    protected void addListeners() {
        super.addListeners();
        this.detect.addListener(13, this.listener);
        this.link.addListener(13, this.createLinkListener());
    }

    protected Listener createLinkListener() {
        return new Listener(){

            public void handleEvent(Event event) {
                ChangePortDialog dialog = PortEditorXPathExtension.this.getDialog();
                int result = dialog.open();
                if (result == 0) {
                    PortEditorXPathExtension.this.currentXPath = dialog.getSelection();
                    PortEditorXPathExtension.this.section.execute((IUndoableOperation)PortEditorXPathExtension.this.getCommand());
                }
                if (dialog.isModified()) {
                    PortEditorXPathExtension.this.initialize();
                    PortEditorXPathExtension.this.validate();
                }
                PortEditorXPathExtension.this.text.setFocus();
            }
        };
    }

    public ChangePortDialog getDialog() {
        return new ChangePortDialog(this.section.getShell(), this.getDialogInfo());
    }

    @Override
    public ServerCommand getCommand() {
        return new SetPortXPathCommand(this.helper.getWorkingCopy(), this.helper, this.changeValueCommandName, this.overrideValueKey, this.detectXPathKey, this.currentXPathKey, this.defaultXPath, this);
    }

    protected ChangePortDialog.ChangePortDialogInfo getDialogInfo() {
        ChangePortDialog.ChangePortDialogInfo info = new ChangePortDialog.ChangePortDialogInfo();
        info.port = this.labelText;
        info.defaultValue = this.defaultXPath;
        info.server = this.helper.getWorkingCopy().getOriginal();
        info.currentXPath = this.currentXPath;
        return info;
    }

    @Override
    public void validate() {
        String errorText;
        this.decoration.hide();
        String v = null;
        if (this.detect.getSelection()) {
            v = PortSection.findPort(this.helper.getServer(), (IPath)new Path(this.defaultXPath));
            errorText = "This port cannot be automatically located. A default value is being displayed";
        } else {
            v = this.text.getText();
            errorText = "The empty string is not a valid port.";
        }
        if ("".equals(v)) {
            this.decoration.setDescriptionText(errorText);
            this.decoration.show();
        }
    }
}

