/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.editor.ports;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.Section;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.ui.editor.ServerEditorSection;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathCategory;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathModel;
import org.jboss.ide.eclipse.as.core.extensions.descriptors.XPathQuery;
import org.jboss.ide.eclipse.as.core.util.ServerAttributeHelper;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.ui.editor.ports.IPortEditorExtension;
import org.jboss.ide.eclipse.as.ui.editor.ports.IPortOffsetProvider;
import org.jboss.ide.eclipse.as.ui.editor.ports.PortEditorExtension;
import org.jboss.ide.eclipse.as.ui.editor.ports.PortEditorXPathExtension;
import org.jboss.tools.foundation.core.expressions.ExpressionResolver;

public class PortSection
extends ServerEditorSection {
    private ArrayList<IPortEditorExtension> sectionList = new ArrayList();
    protected ServerAttributeHelper helper;
    private IPortOffsetProvider offsetProvider;

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        this.helper = new ServerAttributeHelper(this.server.getOriginal(), this.server);
        String serverTypeId = this.server.getServerType().getId();
        if (this.sectionList.size() <= 0) {
            IExtensionRegistry registry = Platform.getExtensionRegistry();
            IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.jboss.ide.eclipse.as.ui", "ServerEditorPortSection");
            ArrayList<IConfigurationElement> approved = new ArrayList<IConfigurationElement>();
            int i = 0;
            while (i < cf.length) {
                String approvedTypes = cf[i].getAttribute("serverIds");
                if (this.serverTypeMatches(serverTypeId, approvedTypes)) {
                    approved.add(cf[i]);
                }
                ++i;
            }
            Collections.sort(approved, new Comparator<IConfigurationElement>(){

                @Override
                public int compare(IConfigurationElement o1, IConfigurationElement o2) {
                    int w2;
                    int w1;
                    String weight1 = o1.getAttribute("weight");
                    String weight2 = o2.getAttribute("weight");
                    weight1 = weight1 == null ? "100" : weight1;
                    weight2 = weight2 == null ? "100" : weight2;
                    try {
                        w1 = Integer.parseInt(weight1);
                    }
                    catch (NumberFormatException nfe) {
                        w1 = 100;
                    }
                    try {
                        w2 = Integer.parseInt(weight2);
                    }
                    catch (NumberFormatException nfe) {
                        w2 = 100;
                    }
                    return w1 - w2;
                }
            });
            i = 0;
            while (i < approved.size()) {
                try {
                    Object o = ((IConfigurationElement)approved.get(i)).createExecutableExtension("class");
                    if (o != null && o instanceof IPortEditorExtension) {
                        this.sectionList.add((IPortEditorExtension)o);
                    }
                    if (o != null && o instanceof IPortOffsetProvider) {
                        this.offsetProvider = (IPortOffsetProvider)o;
                    }
                }
                catch (CoreException ce) {
                    ce.printStackTrace();
                }
                ++i;
            }
        }
    }

    public int getPortOffset() {
        return this.offsetProvider == null ? 0 : this.offsetProvider.getOffset();
    }

    public void offsetChanged() {
        for (IPortEditorExtension ext : this.sectionList) {
            if (ext instanceof IPortOffsetProvider) continue;
            ext.refresh();
        }
    }

    protected boolean serverTypeMatches(String serverType, String approvedTypes) {
        if (approvedTypes == null || approvedTypes.equals("")) {
            return true;
        }
        String[] split = approvedTypes.split(",");
        int i = 0;
        while (i < split.length) {
            if (split[i].equals(serverType)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void createSection(Composite parent) {
        super.createSection(parent);
        this.createUI(parent);
    }

    protected void createUI(Composite parent) {
        FormToolkit toolkit = new FormToolkit(parent.getDisplay());
        Section section = toolkit.createSection(parent, 322);
        section.setText(Messages.EditorServerPorts);
        section.setLayoutData((Object)new GridData(784));
        Composite composite = toolkit.createComposite((Composite)section);
        composite.setLayout((Layout)new FormLayout());
        Label description = new Label(composite, 0);
        description.setText(Messages.EditorServerPortsDescription);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 5);
        data.left = new FormAttachment(0, 5);
        description.setLayoutData((Object)data);
        this.addUIAdditions(composite, (Control)description);
        toolkit.paintBordersFor(composite);
        section.setClient((Control)composite);
    }

    private void addUIAdditions(Composite parent, Control top) {
        IPortEditorExtension[] extensions = this.sectionList.toArray(new IPortEditorExtension[this.sectionList.size()]);
        Composite wrapper = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().margins(6, 10).numColumns(4).applyTo(wrapper);
        FormData data = new FormData();
        data.top = new FormAttachment(top, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, -5);
        wrapper.setLayoutData((Object)data);
        top = null;
        int i = 0;
        while (i < extensions.length) {
            extensions[i].setServerAttributeHelper(this.helper);
            extensions[i].setSection(this);
            extensions[i].createControl(wrapper);
            ++i;
        }
    }

    protected String[] getXPathStrings() {
        ArrayList<String> list = new ArrayList<String>();
        XPathCategory[] categories = XPathModel.getDefault().getCategories(this.server.getOriginal());
        int i = 0;
        while (i < categories.length) {
            XPathQuery[] queries = categories[i].getQueries();
            int j = 0;
            while (j < queries.length) {
                list.add(String.valueOf(categories[i].getName()) + '/' + queries[j].getName());
                ++j;
            }
            ++i;
        }
        return list.toArray(new String[list.size()]);
    }

    protected static String findPortWithDefault(IServer server, IPath path, int defaultValue) {
        return PortSection.findPortWithDefault(server, path, defaultValue, 0);
    }

    protected static String findPortWithDefault(IServer server, IPath path, int defaultValue, int offset) {
        String s = PortSection.findPort(server, path, offset);
        if (s.equals("")) {
            s = new Integer(defaultValue + offset).toString();
        }
        return s;
    }

    protected static String findPort(IServer server, IPath path) {
        return PortSection.findPort(server, path, 0);
    }

    protected static String findPort(IServer server, IPath path, int offset) {
        XPathQuery query = XPathModel.getDefault().getQuery(server, path);
        String result = "";
        if (query != null) {
            try {
                query.refresh();
                result = query.getFirstResult();
                result = result == null ? "" : result;
                result = new ExpressionResolver().resolveIgnoreErrors(result);
                return new Integer(Integer.parseInt(result) + offset).toString();
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return result;
    }

    public static class JBoss6JMXRMIPortEditorExtension
    extends PortEditorXPathExtension {
        public JBoss6JMXRMIPortEditorExtension() {
            super(Messages.EditorJMXRMIPort, "org.jboss.ide.eclipse.as.core.server.jmxrmiport_AutoDetect.XPath", "org.jboss.ide.eclipse.as.core.server.jmxrmiport_AutoDetect", "org.jboss.ide.eclipse.as.core.server.jmxrmiport", "Ports/JMX RMI Port", 1090, Messages.EditorChangeJMXRMICommandName);
        }
    }

    public static class JBoss7ManagementPortEditorExtension
    extends PortEditorXPathExtension {
        public JBoss7ManagementPortEditorExtension() {
            super(Messages.EditorAS7ManagementPort, "org.jboss.ide.eclipse.as.core.server.as7.managementPortAutoDetect.XPath", "org.jboss.ide.eclipse.as.core.server.as7.managementPortAutoDetect", "org.jboss.ide.eclipse.as.core.server.as7.managementPort", "Ports/JBoss Management", 9999, Messages.EditorChangeAS7ManagementCommandName);
        }
    }

    public static class JBoss7PortOffsetEditorExtension
    extends PortEditorXPathExtension
    implements IPortOffsetProvider {
        public JBoss7PortOffsetEditorExtension() {
            super(Messages.EditorAS7PortOffset, "org.jboss.ide.eclipse.as.core.server.portOffsetAutoDetect.XPath", "org.jboss.ide.eclipse.as.core.server.portOffsetAutoDetect", "org.jboss.ide.eclipse.as.core.server.portOffset", "Ports/Port Offset", 0, Messages.EditorChangeAS7ManagementCommandName);
        }

        @Override
        protected void listenerEvent(Event event) {
            this.section.execute((IUndoableOperation)this.getCommand());
            this.section.offsetChanged();
        }

        @Override
        public int getOffset() {
            String v = this.text == null ? "" : this.text.getText();
            int i = "".equals(v) ? 0 : Integer.parseInt(v);
            return i;
        }

        @Override
        protected int discoverOffset() {
            return 0;
        }
    }

    public static class JNDIPortEditorExtension
    extends PortEditorXPathExtension {
        public JNDIPortEditorExtension() {
            super(Messages.EditorJNDIPort, "org.jboss.ide.eclipse.as.core.server.jndiPortAutoDetect.XPath", "org.jboss.ide.eclipse.as.core.server.jndiPortAutoDetect", "org.jboss.ide.eclipse.as.core.server.jndiPort", "Ports/JNDI", 1099, Messages.EditorChangeJNDICommandName);
        }
    }

    public static class WebPortEditorExtension
    extends PortEditorXPathExtension {
        public WebPortEditorExtension() {
            super(Messages.EditorWebPort, "org.jboss.ide.eclipse.as.core.server.webPortAutoDetect.XPath", "org.jboss.ide.eclipse.as.core.server.webPortAutoDetect", "org.jboss.ide.eclipse.as.core.server.webPort", "Ports/JBoss Web", 8080, Messages.EditorChangeWebCommandName);
        }
    }

    public static class WebPortSettingEditorExtension
    extends PortEditorExtension {
        public WebPortSettingEditorExtension() {
            super(Messages.EditorWebPort, "org.jboss.ide.eclipse.as.core.server.webPort", 8080, Messages.EditorChangeWebCommandName);
        }
    }
}

