/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.views.server.extensions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.navigator.CommonActionProvider;
import org.eclipse.ui.navigator.ICommonActionExtensionSite;
import org.eclipse.ui.navigator.ICommonViewerSite;
import org.eclipse.ui.navigator.ICommonViewerWorkbenchSite;
import org.eclipse.wst.server.core.IModule;
import org.eclipse.wst.server.core.IServer;
import org.eclipse.wst.server.core.IServerWorkingCopy;
import org.eclipse.wst.server.core.ServerCore;
import org.eclipse.wst.server.core.ServerUtil;
import org.eclipse.wst.server.core.internal.Server;
import org.eclipse.wst.server.ui.internal.view.servers.ModuleServer;
import org.jboss.ide.eclipse.as.ui.JBossServerUISharedImages;
import org.jboss.ide.eclipse.as.ui.Messages;
import org.jboss.ide.eclipse.as.wtp.core.util.ServerModelUtilities;

public class ModuleActionProvider
extends CommonActionProvider {
    private Action fullPublishModuleAction;
    private Action incrementalPublishModuleAction;
    private ModuleServer[] selection;
    private ICommonActionExtensionSite actionSite;

    public void init(ICommonActionExtensionSite aSite) {
        super.init(aSite);
        this.actionSite = aSite;
        this.createActions();
    }

    public void fillContextMenu(IMenuManager menu) {
        ICommonViewerSite site = this.actionSite.getViewSite();
        IStructuredSelection selection = null;
        if (site instanceof ICommonViewerWorkbenchSite) {
            ICommonViewerWorkbenchSite wsSite = (ICommonViewerWorkbenchSite)site;
            selection = (IStructuredSelection)wsSite.getSelectionProvider().getSelection();
        }
        if (this.allAre(selection, ModuleServer.class)) {
            Object[] arr = selection.toArray();
            ModuleServer[] ms = new ModuleServer[arr.length];
            int i = 0;
            while (i < arr.length) {
                ms[i] = (ModuleServer)arr[i];
                ++i;
            }
            this.selection = ms;
            IContributionItem sep = menu.find("org.eclipse.wst.server.ui.internal.cnf.controlModuleSectionEnd");
            if (sep == null) {
                sep = new Separator("org.eclipse.wst.server.ui.internal.cnf.controlModuleSectionEnd");
                sep.setVisible(false);
                menu.add(sep);
            }
            menu.insertBefore("org.eclipse.wst.server.ui.internal.cnf.controlModuleSectionEnd", (IAction)this.incrementalPublishModuleAction);
            menu.insertBefore("org.eclipse.wst.server.ui.internal.cnf.controlModuleSectionEnd", (IAction)this.fullPublishModuleAction);
        }
    }

    protected boolean allAre(IStructuredSelection sel, Class c) {
        if (sel == null || sel.isEmpty()) {
            return false;
        }
        Iterator i = sel.iterator();
        while (i.hasNext()) {
            if (i.next().getClass().equals(c)) continue;
            return false;
        }
        return true;
    }

    protected void createActions() {
        this.fullPublishModuleAction = new Action(){

            public void run() {
                ModuleActionProvider.this.actionPublish(3);
            }
        };
        this.fullPublishModuleAction.setText(Messages.FullPublishModuleText);
        this.fullPublishModuleAction.setDescription(Messages.PublishModuleDescription);
        this.fullPublishModuleAction.setImageDescriptor(JBossServerUISharedImages.getImageDescriptor("PUBLISH_IMAGE"));
        this.incrementalPublishModuleAction = new Action(){

            public void run() {
                ModuleActionProvider.this.actionPublish(2);
            }
        };
        this.incrementalPublishModuleAction.setText(Messages.IncrementalPublishModuleText);
        this.incrementalPublishModuleAction.setDescription(Messages.PublishModuleDescription);
        this.incrementalPublishModuleAction.setImageDescriptor(JBossServerUISharedImages.getImageDescriptor("PUBLISH_IMAGE"));
    }

    protected void actionPublish(int type) {
        if (this.selection != null && this.selection.length > 0) {
            Server s = (Server)this.selection[0].server;
            IServer tmp = ServerCore.findServer((String)s.getId());
            int i = 0;
            while (i < this.selection.length) {
                IModule[] mod = this.selection[i].module;
                s.setModulePublishState(mod, type);
                ArrayList allChildren = ServerModelUtilities.getDeepChildren((IServer)s, (IModule[])mod);
                int j = 0;
                while (j < allChildren.size()) {
                    s.setModulePublishState((IModule[])allChildren.get(j), type);
                    ++j;
                }
                ++i;
            }
            Server s2 = s;
            new Thread((IServer)s2){
                private final /* synthetic */ IServer val$s2;
                {
                    this.val$s2 = iServer;
                }

                @Override
                public void run() {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.val$s2.publish(1, null, ModuleActionProvider.this.getUserInitiatedAdaptable(), null);
                }
            }.start();
        }
    }

    protected void deleteModule() {
        if (MessageDialog.openConfirm((Shell)new Shell(), (String)Messages.ServerDialogHeading, (String)Messages.DeleteModuleConfirm)) {
            Thread t = new Thread(){

                @Override
                public void run() {
                    try {
                        if (ModuleActionProvider.this.selection.length > 0 && ((ModuleActionProvider)ModuleActionProvider.this).selection[0].server != null) {
                            IServer server = ((ModuleActionProvider)ModuleActionProvider.this).selection[0].server;
                            ArrayList<IModule> topModsToRemove = new ArrayList<IModule>();
                            int i = 0;
                            while (i < ModuleActionProvider.this.selection.length) {
                                if (!topModsToRemove.contains(((ModuleActionProvider)ModuleActionProvider.this).selection[i].module[0])) {
                                    topModsToRemove.add(((ModuleActionProvider)ModuleActionProvider.this).selection[i].module[0]);
                                }
                                ++i;
                            }
                            IServerWorkingCopy serverWC = server.createWorkingCopy();
                            IModule[] modsToRemove = topModsToRemove.toArray(new IModule[topModsToRemove.size()]);
                            ServerUtil.modifyModules((IServerWorkingCopy)serverWC, (IModule[])new IModule[0], (IModule[])modsToRemove, (IProgressMonitor)new NullProgressMonitor());
                            IServer server2 = serverWC.save(true, null);
                            server2.publish(1, null, ModuleActionProvider.this.getUserInitiatedAdaptable(), null);
                        }
                    }
                    catch (CoreException coreException) {
                        // empty catch block
                    }
                }
            };
            t.start();
        }
    }

    public IAdaptable getUserInitiatedAdaptable() {
        IAdaptable info = new IAdaptable(){

            public Object getAdapter(Class adapter) {
                if (String.class.equals((Object)adapter)) {
                    return "user";
                }
                return null;
            }
        };
        return info;
    }
}

