/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ide.eclipse.as.ui.views.server.extensions;

import java.util.Properties;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.ControlAdapter;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.jboss.ide.eclipse.as.ui.Messages;

public class PropertySheetFactory {
    public static TreeTablePropertySheetPage createTreeTablePropertySheetPage() {
        return new TreeTablePropertySheetPage();
    }

    public static SimplePropertiesPropertySheetPage createSimplePropertiesSheet(ISimplePropertiesHolder holder) {
        return new SimplePropertiesPropertySheetPage(holder);
    }

    public static interface ISimplePropertiesHolder {
        public Properties getProperties(Object var1);
    }

    public static class SimplePropertiesContentProvider
    extends LabelProvider
    implements ITableLabelProvider,
    ITreeContentProvider {
        protected Properties properties;
        protected ISimplePropertiesHolder holder;
        protected Object input;

        public SimplePropertiesContentProvider(ISimplePropertiesHolder holder2) {
            this.holder = holder2;
        }

        public Object[] getElements(Object inputElement) {
            if (this.properties != null) {
                return this.properties.keySet().toArray();
            }
            return new Object[0];
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
            this.input = newInput;
            this.properties = this.holder.getProperties(newInput);
        }

        public Object[] getChildren(Object parentElement) {
            return new Object[0];
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }

        public Image getColumnImage(Object element, int columnIndex) {
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return element.toString();
            }
            if (columnIndex == 1 && element instanceof String && this.properties != null) {
                return this.properties.getProperty((String)element);
            }
            return null;
        }
    }

    public static class SimplePropertiesPropertySheetPage
    implements IPropertySheetPage {
        private ISimplePropertiesHolder holder;
        private SimplePropertiesContentProvider provider;
        private TreeTablePropertySheetPage sheet;

        public SimplePropertiesPropertySheetPage(ISimplePropertiesHolder holder) {
            this.holder = holder;
            this.sheet = new TreeTablePropertySheetPage();
        }

        public void createControl(Composite parent) {
            this.sheet.createControl(parent);
            this.provider = new SimplePropertiesContentProvider(this.holder);
            this.sheet.setContentProvider(this.provider);
            this.sheet.setLabelProvider(this.provider);
        }

        public void dispose() {
            this.sheet.dispose();
        }

        public Control getControl() {
            return this.sheet.getControl();
        }

        public void setActionBars(IActionBars actionBars) {
            this.sheet.setActionBars(actionBars);
        }

        public void setFocus() {
            this.sheet.setFocus();
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            this.sheet.selectionChanged(part, selection);
        }
    }

    public static class TreeTablePropertySheetPage
    implements IPropertySheetPage {
        protected TreeViewer propertiesViewer;
        protected Composite control;

        public void createControl(Composite parent) {
            this.control = new Composite(parent, 0);
            this.control.setLayout((Layout)new FillLayout());
            Tree tTable = new Tree(this.control, 66308);
            tTable.setHeaderVisible(true);
            tTable.setLinesVisible(true);
            tTable.setLayoutData((Object)new GridData(1808));
            tTable.setFont(this.control.getFont());
            TreeColumn column = new TreeColumn(tTable, 4);
            column.setText(Messages.property);
            TreeColumn column2 = new TreeColumn(tTable, 4);
            column2.setText(Messages.value);
            final Tree tree2 = tTable;
            tree2.addControlListener((ControlListener)new ControlAdapter(){

                public void controlResized(ControlEvent e) {
                    Rectangle area = tree2.getClientArea();
                    TreeColumn[] columns = tree2.getColumns();
                    if (area.width > 0) {
                        columns[0].setWidth(area.width * 40 / 100);
                        columns[1].setWidth(area.width - columns[0].getWidth() - 4);
                        tree2.removeControlListener((ControlListener)this);
                    }
                }
            });
            this.propertiesViewer = new TreeViewer(tTable);
        }

        public void dispose() {
        }

        public Control getControl() {
            return this.control;
        }

        public void setActionBars(IActionBars actionBars) {
        }

        public void setFocus() {
        }

        public void selectionChanged(IWorkbenchPart part, ISelection selection) {
            Object o;
            if (selection instanceof IStructuredSelection && (o = ((IStructuredSelection)selection).getFirstElement()) != null) {
                this.propertiesViewer.setInput(o);
            }
        }

        public void setContentProvider(ITreeContentProvider provider) {
            this.propertiesViewer.setContentProvider((IContentProvider)provider);
        }

        public void setLabelProvider(ITableLabelProvider provider) {
            this.propertiesViewer.setLabelProvider((IBaseLabelProvider)provider);
        }
    }
}

